/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.nativeplatform;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import net.fabricmc.loom.nativeplatform.OperatingSystem;

class LoomNativePlatformUtils {
    private static final String OS_ID = OperatingSystem.CURRENT.name().toLowerCase(Locale.ROOT) + "-" + System.getProperty("os.arch").toLowerCase(Locale.ROOT);
    private static final Map<String, String> NATIVE_LIBS = Map.of("windows-aarch64", "fabric-loom-native/aarch64/fabric-loom-native.dll", "windows-win32", "fabric-loom-native/x86/fabric-loom-native.dll", "windows-amd64", "fabric-loom-native/x86-64/fabric-loom-native.dll");
    private static boolean initialized = false;
    private static boolean isReady = false;

    LoomNativePlatformUtils() {
    }

    static synchronized boolean isReady() {
        if (initialized) {
            return isReady;
        }
        initialized = true;
        if (!NATIVE_LIBS.containsKey(OS_ID)) {
            return false;
        }
        try {
            LoomNativePlatformUtils.loadLibrary();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return isReady;
    }

    private static void loadLibrary() throws IOException {
        String nativeName = NATIVE_LIBS.get(OS_ID);
        Path nativePath = Files.createTempFile("fabric-loom-native", ".dll", new FileAttribute[0]);
        try (InputStream is = LoomNativePlatformUtils.class.getClassLoader().getResourceAsStream(nativeName);){
            Objects.requireNonNull(is, "Could not load: " + nativeName);
            Files.copy(is, nativePath, StandardCopyOption.REPLACE_EXISTING);
        }
        System.load(nativePath.toString());
        isReady = true;
    }
}

