/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.fabricmc.loom.LoomRepositoryPlugin;
import net.fabricmc.loom.api.LoomGradleExtensionAPI;
import net.fabricmc.loom.bootstrap.BootstrappedPlugin;
import net.fabricmc.loom.configuration.CompileConfiguration;
import net.fabricmc.loom.configuration.FabricApiExtension;
import net.fabricmc.loom.configuration.LoomConfigurations;
import net.fabricmc.loom.configuration.MavenPublication;
import net.fabricmc.loom.configuration.ide.idea.IdeaConfiguration;
import net.fabricmc.loom.configuration.sandbox.SandboxConfiguration;
import net.fabricmc.loom.decompilers.DecompilerConfiguration;
import net.fabricmc.loom.extension.LoomFiles;
import net.fabricmc.loom.extension.LoomGradleExtensionImpl;
import net.fabricmc.loom.task.LoomTasks;
import net.fabricmc.loom.task.RemapTaskConfiguration;
import net.fabricmc.loom.util.LibraryLocationLogger;
import org.gradle.api.Project;
import org.gradle.api.plugins.PluginAware;

public class LoomGradlePlugin
implements BootstrappedPlugin {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static final String LOOM_VERSION = Objects.requireNonNullElse(LoomGradlePlugin.class.getPackage().getImplementationVersion(), "0.0.0+unknown");
    private static final List<Class<? extends Runnable>> SETUP_JOBS = List.of(LoomConfigurations.class, CompileConfiguration.class, MavenPublication.class, RemapTaskConfiguration.class, LoomTasks.class, DecompilerConfiguration.class, IdeaConfiguration.class, SandboxConfiguration.class);

    @Override
    public void apply(PluginAware target) {
        target.getPlugins().apply(LoomRepositoryPlugin.class);
        if (target instanceof Project) {
            Project project = (Project)target;
            this.apply(project);
        }
    }

    public void apply(Project project) {
        project.getLogger().lifecycle("Fabric Loom: " + LOOM_VERSION);
        LibraryLocationLogger.logLibraryVersions();
        project.apply((Map)ImmutableMap.of((Object)"plugin", (Object)"java-library"));
        project.apply((Map)ImmutableMap.of((Object)"plugin", (Object)"eclipse"));
        project.getExtensions().create(LoomGradleExtensionAPI.class, "loom", LoomGradleExtensionImpl.class, new Object[]{project, LoomFiles.create(project)});
        project.getExtensions().create("fabricApi", FabricApiExtension.class, new Object[0]);
        for (Class<? extends Runnable> jobClass : SETUP_JOBS) {
            ((Runnable)project.getObjects().newInstance(jobClass, new Object[0])).run();
        }
    }
}

