/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.mods;

import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.Supplier;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.LoomGradlePlugin;
import net.fabricmc.loom.api.RemapConfigurationSettings;
import net.fabricmc.loom.configuration.RemapConfigurations;
import net.fabricmc.loom.configuration.mods.ArtifactMetadata;
import net.fabricmc.loom.configuration.mods.ArtifactRef;
import net.fabricmc.loom.configuration.mods.ModProcessor;
import net.fabricmc.loom.configuration.mods.dependency.ModDependency;
import net.fabricmc.loom.configuration.mods.dependency.ModDependencyFactory;
import net.fabricmc.loom.util.Checksum;
import net.fabricmc.loom.util.ExceptionUtil;
import net.fabricmc.loom.util.SourceRemapper;
import net.fabricmc.loom.util.gradle.SourceSetHelper;
import net.fabricmc.loom.util.service.ServiceFactory;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.DependencyConstraint;
import org.gradle.api.artifacts.FileCollectionDependency;
import org.gradle.api.artifacts.MutableVersionConstraint;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.artifacts.query.ArtifactResolutionQuery;
import org.gradle.api.artifacts.result.ArtifactResult;
import org.gradle.api.artifacts.result.ComponentArtifactsResult;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.attributes.Usage;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.SourceSet;
import org.gradle.jvm.JvmLibrary;
import org.gradle.language.base.artifact.SourcesArtifact;
import org.jetbrains.annotations.Nullable;

public class ModConfigurationRemapper {
    public static final String MISSING_GROUP = "unspecified";

    public static void supplyModConfigurations(Project project, ServiceFactory serviceFactory, String mappingsSuffix, LoomGradleExtension extension, SourceRemapper sourceRemapper) {
        DependencyHandler dependencies = project.getDependencies();
        LinkedHashMap<Configuration, Configuration> configsToRemap = new LinkedHashMap<Configuration, Configuration>();
        HashMap clientConfigsToRemap = new HashMap();
        List<RemapConfigurationSettings> remapConfigurationSettings = extension.getRemapConfigurations().stream().sorted(Comparator.comparing(setting -> !setting.getName().equals("modImplementation"))).toList();
        for (RemapConfigurationSettings entry : remapConfigurationSettings) {
            ImmutableMap envToEnabled = ImmutableMap.of((Object)false, (Object)((Boolean)entry.getOnCompileClasspath().get()), (Object)true, (Object)((Boolean)entry.getOnRuntimeClasspath().get()));
            envToEnabled.forEach((runtime, enabled) -> {
                if (!enabled.booleanValue()) {
                    return;
                }
                Configuration target = RemapConfigurations.getOrCreateCollectorConfiguration(project, entry, (boolean)runtime);
                Configuration sourceCopy = ((Configuration)entry.getSourceConfiguration().get()).copyRecursive();
                Usage usage = (Usage)project.getObjects().named(Usage.class, runtime != false ? "java-runtime" : "java-api");
                sourceCopy.attributes(attributes -> attributes.attribute(Usage.USAGE_ATTRIBUTE, (Object)usage));
                sourceCopy.setCanBeConsumed(false);
                configsToRemap.put(sourceCopy, target);
                if (entry.getClientSourceConfigurationName().isPresent()) {
                    SourceSet clientSourceSet = SourceSetHelper.getSourceSetByName("client", project);
                    Configuration clientTarget = RemapConfigurations.getOrCreateCollectorConfiguration(project, clientSourceSet, (boolean)runtime);
                    clientConfigsToRemap.put(sourceCopy, clientTarget);
                }
            });
            if (!((String)entry.getTargetConfigurationName().get()).equals("api")) continue;
            Configuration remappedConfig2 = (Configuration)project.getConfigurations().maybeCreate(entry.getRemappedConfigurationName());
            remappedConfig2.setTransitive(false);
            project.getConfigurations().getByName("namedElements").extendsFrom(new Configuration[]{remappedConfig2});
            configsToRemap.put((Configuration)entry.getSourceConfiguration().get(), remappedConfig2);
        }
        HashMap dependenciesBySourceConfig = new HashMap();
        HashMap metaCache = new HashMap();
        configsToRemap.forEach((sourceConfig, remappedConfig) -> {
            Configuration clientRemappedConfig = (Configuration)clientConfigsToRemap.get(sourceConfig);
            ArrayList<ModDependency> modDependencies = new ArrayList<ModDependency>();
            for (ArtifactRef artifact : ModConfigurationRemapper.resolveArtifacts(project, sourceConfig)) {
                ArtifactMetadata artifactMetadata = metaCache.computeIfAbsent(artifact, a -> {
                    try {
                        return ArtifactMetadata.create(a, LoomGradlePlugin.LOOM_VERSION);
                    }
                    catch (IOException e) {
                        throw ExceptionUtil.createDescriptiveWrapper(UncheckedIOException::new, "Failed to read metadata from " + String.valueOf(a.path()), e);
                    }
                });
                if (artifactMetadata.installerData() != null) {
                    if (extension.getInstallerData() != null) {
                        project.getLogger().info("Found another installer JSON in ({}), ignoring", (Object)artifact.path());
                    } else {
                        project.getLogger().info("Applying installer data from {}", (Object)artifact.path());
                        artifactMetadata.installerData().applyToProject(project);
                    }
                }
                if (!artifactMetadata.shouldRemap()) {
                    artifact.applyToConfiguration(project, (Configuration)remappedConfig);
                    continue;
                }
                ModDependency modDependency = ModDependencyFactory.create(artifact, artifactMetadata, remappedConfig, clientRemappedConfig, mappingsSuffix, project);
                ModConfigurationRemapper.scheduleSourcesRemapping(project, sourceRemapper, modDependency);
                modDependencies.add(modDependency);
            }
            dependenciesBySourceConfig.put(sourceConfig, modDependencies);
        });
        configsToRemap.forEach((sourceConfig, remappedConfig) -> {
            List modDependencies = (List)dependenciesBySourceConfig.get(sourceConfig);
            if (modDependencies.isEmpty()) {
                return;
            }
            Configuration clientRemappedConfig = (Configuration)clientConfigsToRemap.get(sourceConfig);
            boolean refreshDeps = LoomGradleExtension.get(project).refreshDeps();
            List<ModDependency> toRemap = modDependencies.stream().filter(dependency -> refreshDeps || dependency.isCacheInvalid(project, null)).toList();
            if (!toRemap.isEmpty()) {
                try {
                    new ModProcessor(project, (Configuration)sourceConfig, serviceFactory).processMods(toRemap);
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Failed to remap mods", e);
                }
            }
            for (ModDependency info : modDependencies) {
                info.applyToProject(project);
                ModConfigurationRemapper.createConstraints(info.getInputArtifact(), remappedConfig, sourceConfig, dependencies);
                if (clientRemappedConfig == null) continue;
                ModConfigurationRemapper.createConstraints(info.getInputArtifact(), clientRemappedConfig, sourceConfig, dependencies);
            }
        });
    }

    private static void createConstraints(ArtifactRef artifact, Configuration targetConfig, Configuration sourceConfig, DependencyHandler dependencies) {
    }

    private static List<ArtifactRef> resolveArtifacts(Project project, Configuration configuration) {
        ArrayList<ArtifactRef> artifacts = new ArrayList<ArtifactRef>();
        for (ResolvedArtifact artifact : configuration.getResolvedConfiguration().getResolvedArtifacts()) {
            Path sources = ModConfigurationRemapper.findSources(project, artifact);
            artifacts.add(new ArtifactRef.ResolvedArtifactRef(artifact, sources));
        }
        for (FileCollectionDependency dependency : configuration.getAllDependencies().withType(FileCollectionDependency.class)) {
            String group = ModConfigurationRemapper.replaceIfNullOrEmpty(dependency.getGroup(), () -> MISSING_GROUP);
            FileCollection files = dependency.getFiles();
            for (File artifact : files) {
                String name = ModConfigurationRemapper.getNameWithoutExtension(artifact.toPath());
                String version = ModConfigurationRemapper.replaceIfNullOrEmpty(dependency.getVersion(), () -> Checksum.truncatedSha256(artifact));
                artifacts.add(new ArtifactRef.FileArtifactRef(artifact.toPath(), group, name, version));
            }
        }
        return artifacts;
    }

    private static String getNameWithoutExtension(Path file) {
        String fileName = file.getFileName().toString();
        int dotIndex = fileName.lastIndexOf(46);
        return dotIndex == -1 ? fileName : fileName.substring(0, dotIndex);
    }

    @Nullable
    public static Path findSources(Project project, ResolvedArtifact artifact) {
        if (ModConfigurationRemapper.isCIBuild()) {
            return null;
        }
        DependencyHandler dependencies = project.getDependencies();
        ArtifactResolutionQuery query = dependencies.createArtifactResolutionQuery().forComponents(new ComponentIdentifier[]{artifact.getId().getComponentIdentifier()}).withArtifacts(JvmLibrary.class, new Class[]{SourcesArtifact.class});
        for (ComponentArtifactsResult result : query.execute().getResolvedComponents()) {
            for (ArtifactResult srcArtifact : result.getArtifacts(SourcesArtifact.class)) {
                if (!(srcArtifact instanceof ResolvedArtifactResult)) continue;
                return ((ResolvedArtifactResult)srcArtifact).getFile().toPath();
            }
        }
        return null;
    }

    private static void scheduleSourcesRemapping(Project project, SourceRemapper sourceRemapper, ModDependency dependency) {
        if (ModConfigurationRemapper.isCIBuild()) {
            return;
        }
        Path sourcesInput = dependency.getInputArtifact().sources();
        if (sourcesInput == null || Files.notExists(sourcesInput, new LinkOption[0])) {
            return;
        }
        if (dependency.isCacheInvalid(project, "sources")) {
            Path output = dependency.getWorkingFile("sources");
            sourceRemapper.scheduleRemapSources(sourcesInput.toFile(), output.toFile(), false, true, () -> {
                try {
                    dependency.copyToCache(project, output, "sources");
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Failed to apply sources to local cache for: " + String.valueOf(dependency), e);
                }
            });
        }
    }

    public static String replaceIfNullOrEmpty(@Nullable String s, Supplier<String> fallback) {
        return s == null || s.isEmpty() ? fallback.get() : s;
    }

    private static boolean isCIBuild() {
        String loomProperty = System.getProperty("fabric.loom.ci");
        if (loomProperty != null) {
            return loomProperty.equalsIgnoreCase("true");
        }
        return System.getenv("CI") != null;
    }

    private static /* synthetic */ void lambda$createConstraints$7(Configuration targetConfig, Configuration sourceConfig, DependencyConstraint constraint) {
        constraint.because("configuration (%s) already contains the remapped module from configuration (%s)".formatted(targetConfig.getName(), sourceConfig.getName()));
        constraint.version(MutableVersionConstraint::rejectAll);
    }
}

