/*
 * This file is part of fabric-loom, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2016-2020 FabricMC
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package net.fabricmc.loom.util;

import java.io.OutputStream;
import java.util.function.Consumer;

/**
 * Created by covers1624 on 20/12/18.
 */
public class ConsumingOutputStream extends OutputStream {
	private final Consumer<String> consumer;

	private StringBuilder buffer = new StringBuilder();

	public ConsumingOutputStream(Consumer<String> consumer) {
		this.consumer = consumer;
	}

	@Override
	public void write(int b) {
		char ch = (char) (b & 0xFF);
		buffer.append(ch);

		if (ch == '\n' || ch == '\r') {
			flush();
		}
	}

	@Override
	public void flush() {
		String str = buffer.toString();

		if (str.endsWith("\r") || str.endsWith("\n")) {
			str = str.trim();

			if (!str.isEmpty()) {
				consumer.accept(str);
			}

			buffer = new StringBuilder();
		}
	}
}
