/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.providers.mappings.extras.unpick;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import net.fabricmc.loom.LoomGradlePlugin;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public interface UnpickLayer {
    @Nullable
    public UnpickData getUnpickData() throws IOException;

    public record UnpickData(Metadata metadata, byte[] definitions) {
        public static UnpickData read(Path metadataPath, Path definitionPath) throws IOException {
            Metadata metadata;
            byte[] definitions = Files.readAllBytes(definitionPath);
            try (BufferedReader reader = Files.newBufferedReader(metadataPath, StandardCharsets.UTF_8);){
                metadata = (Metadata)LoomGradlePlugin.GSON.fromJson((Reader)reader, Metadata.class);
            }
            return new UnpickData(metadata, definitions);
        }

        public record Metadata(int version, String unpickGroup, String unpickVersion) {
            public String asJson() {
                return LoomGradlePlugin.GSON.toJson((Object)this);
            }
        }
    }
}

