/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.providers.mappings.file;

import java.util.Objects;
import net.fabricmc.loom.api.mappings.layered.MappingsNamespace;
import net.fabricmc.loom.api.mappings.layered.spec.FileMappingsSpecBuilder;
import net.fabricmc.loom.api.mappings.layered.spec.FileSpec;
import net.fabricmc.loom.configuration.providers.mappings.file.FileMappingsSpec;

public class FileMappingsSpecBuilderImpl
implements FileMappingsSpecBuilder {
    private static final String DEFAULT_MAPPING_PATH = "mappings/mappings.tiny";
    private final FileSpec fileSpec;
    private String mappingPath = "mappings/mappings.tiny";
    private String fallbackSourceNamespace = MappingsNamespace.INTERMEDIARY.toString();
    private String fallbackTargetNamespace = MappingsNamespace.NAMED.toString();
    private boolean enigma = false;
    private boolean unpick = false;
    private String mergeNamespace = MappingsNamespace.INTERMEDIARY.toString();

    private FileMappingsSpecBuilderImpl(FileSpec fileSpec) {
        this.fileSpec = fileSpec;
    }

    public static FileMappingsSpecBuilderImpl builder(FileSpec fileSpec) {
        return new FileMappingsSpecBuilderImpl(fileSpec);
    }

    @Override
    public FileMappingsSpecBuilderImpl mappingPath(String mappingPath) {
        this.mappingPath = Objects.requireNonNull(mappingPath, "mapping path cannot be null");
        return this;
    }

    @Override
    public FileMappingsSpecBuilderImpl fallbackNamespaces(String sourceNamespace, String targetNamespace) {
        this.fallbackSourceNamespace = Objects.requireNonNull(sourceNamespace, "fallback source namespace cannot be null");
        this.fallbackTargetNamespace = Objects.requireNonNull(targetNamespace, "fallback target namespace cannot be null");
        return this;
    }

    @Override
    public FileMappingsSpecBuilderImpl enigmaMappings() {
        this.enigma = true;
        return this;
    }

    @Override
    public FileMappingsSpecBuilderImpl containsUnpick() {
        this.unpick = true;
        return this;
    }

    @Override
    public FileMappingsSpecBuilderImpl mergeNamespace(MappingsNamespace namespace) {
        this.mergeNamespace = Objects.requireNonNull(namespace, "merge namespace cannot be null").toString();
        return this;
    }

    @Override
    public FileMappingsSpecBuilderImpl mergeNamespace(String namespace) {
        Objects.requireNonNull(namespace, "merge namespace cannot be null");
        if (MappingsNamespace.of(namespace) == null) {
            throw new IllegalArgumentException("Namespace '" + namespace + "' is unsupported! It must be either 'official', 'intermediary' or 'named'.");
        }
        this.mergeNamespace = namespace;
        return this;
    }

    public FileMappingsSpec build() {
        return new FileMappingsSpec(this.fileSpec, this.mappingPath, this.fallbackSourceNamespace, this.fallbackTargetNamespace, this.enigma, this.unpick, this.mergeNamespace);
    }
}

