/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.extension;

import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import net.fabricmc.loom.extension.MixinExtension;
import net.fabricmc.loom.extension.MixinExtensionApiImpl;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.UnknownTaskException;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.plugins.BasePluginExtension;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.util.PatternSet;
import org.jetbrains.annotations.NotNull;

public class MixinExtensionImpl
extends MixinExtensionApiImpl
implements MixinExtension {
    private boolean isDefault = true;
    private final Property<String> defaultRefmapName;

    @Inject
    public MixinExtensionImpl(Project project) {
        super(project);
        this.defaultRefmapName = project.getObjects().property(String.class).convention(project.provider(this::getDefaultMixinRefmapName));
    }

    @Override
    public Property<String> getDefaultRefmapName() {
        if (!((Boolean)super.getUseLegacyMixinAp().get()).booleanValue()) {
            throw new IllegalStateException("You need to set useLegacyMixinAp = true to configure Mixin annotation processor.");
        }
        return this.defaultRefmapName;
    }

    private String getDefaultMixinRefmapName() {
        String defaultRefmapName = (String)((BasePluginExtension)this.project.getExtensions().getByType(BasePluginExtension.class)).getArchivesName().get() + "-refmap.json";
        this.project.getLogger().info("Could not find refmap definition, will be using default name: " + defaultRefmapName);
        return defaultRefmapName;
    }

    @Override
    protected PatternSet add0(SourceSet sourceSet, Provider<String> refmapName) {
        if (!((Boolean)super.getUseLegacyMixinAp().get()).booleanValue()) {
            throw new IllegalStateException("You need to set useLegacyMixinAp = true to configure Mixin annotation processor.");
        }
        PatternSet pattern = new PatternSet().setIncludes(Collections.singletonList("**/*.json"));
        MixinExtension.setMixinInformationContainer(sourceSet, new MixinExtension.MixinInformationContainer(sourceSet, refmapName, pattern));
        this.isDefault = false;
        return pattern;
    }

    @Override
    @NotNull
    public Stream<SourceSet> getMixinSourceSetsStream() {
        return ((JavaPluginExtension)this.project.getExtensions().getByType(JavaPluginExtension.class)).getSourceSets().stream().filter(sourceSet -> MixinExtension.getMixinInformationContainer(sourceSet) != null);
    }

    @Override
    @NotNull
    public Stream<Configuration> getApConfigurationsStream(Function<SourceSet, String> getApConfigNameFunc) {
        return this.getMixinSourceSetsStream().map(sourceSet -> this.project.getConfigurations().getByName((String)getApConfigNameFunc.apply((SourceSet)sourceSet)));
    }

    @Override
    @NotNull
    public Stream<Map.Entry<SourceSet, Task>> getInvokerTasksStream(String compileTaskLanguage) {
        return this.getMixinSourceSetsStream().flatMap(sourceSet -> {
            try {
                Task task = this.project.getTasks().getByName(sourceSet.getCompileTaskName(compileTaskLanguage));
                return Stream.of(new AbstractMap.SimpleEntry<SourceSet, Task>((SourceSet)sourceSet, task));
            }
            catch (UnknownTaskException ignored) {
                return Stream.empty();
            }
        });
    }

    @Override
    @Input
    @NotNull
    public Collection<SourceSet> getMixinSourceSets() {
        return this.getMixinSourceSetsStream().collect(Collectors.toList());
    }

    @Override
    public void init() {
        if (this.isDefault) {
            this.initDefault();
        }
        this.isDefault = false;
    }

    private void initDefault() {
        ((JavaPluginExtension)this.project.getExtensions().getByType(JavaPluginExtension.class)).getSourceSets().forEach(sourceSet -> {
            if (sourceSet.getName().equals("main")) {
                this.add((SourceSet)sourceSet);
            } else {
                this.add((SourceSet)sourceSet, sourceSet.getName() + "-" + (String)this.getDefaultRefmapName().get());
            }
        });
    }
}

