/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.task;

import net.fabricmc.loom.task.AbstractLoomTask;
import net.fabricmc.loom.task.service.MigrateMappingsService;
import net.fabricmc.loom.util.service.ScopedServiceFactory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.options.Option;
import org.gradle.work.DisableCachingByDefault;

@DisableCachingByDefault(because="Always rerun this task.")
public abstract class MigrateMappingsTask
extends AbstractLoomTask {
    @Input
    @Option(option="mappings", description="Target mappings")
    public abstract Property<String> getMappings();

    @InputDirectory
    @Option(option="input", description="Java source file directory")
    public abstract DirectoryProperty getInputDir();

    @OutputDirectory
    @Option(option="output", description="Remapped source output directory")
    public abstract DirectoryProperty getOutputDir();

    @Nested
    protected abstract Property<MigrateMappingsService.Options> getMigrationServiceOptions();

    public MigrateMappingsTask() {
        this.getInputDir().convention(this.getProject().getLayout().getProjectDirectory().dir("src/main/java"));
        this.getOutputDir().convention(this.getProject().getLayout().getProjectDirectory().dir("remappedSrc"));
        this.getMigrationServiceOptions().set(MigrateMappingsService.createOptions(this.getProject(), this.getMappings(), this.getInputDir(), this.getOutputDir()));
    }

    @TaskAction
    public void doTask() throws Throwable {
        try (ScopedServiceFactory serviceFactory = new ScopedServiceFactory();){
            MigrateMappingsService service = (MigrateMappingsService)serviceFactory.get((MigrateMappingsService.Options)this.getMigrationServiceOptions().get());
            service.migrateMapppings();
        }
    }
}

