/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.task.prod;

import java.io.File;
import javax.inject.Inject;
import net.fabricmc.loom.task.prod.AbstractProductionRunTask;
import net.fabricmc.loom.util.Platform;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.jvm.toolchain.JavaLauncher;
import org.gradle.process.ExecSpec;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Experimental
public abstract class ClientProductionRunTask
extends AbstractProductionRunTask {
    @Input
    public abstract Property<Boolean> getUseXVFB();

    @Input
    protected abstract Property<String> getAssetsIndex();

    @InputFiles
    protected abstract DirectoryProperty getAssetsDir();

    @Inject
    public ClientProductionRunTask() {
        this.getUseXVFB().convention(this.getProject().getProviders().environmentVariable("CI").map(value -> Platform.CURRENT.getOperatingSystem().isLinux()).orElse((Object)false));
        this.getAssetsIndex().set(this.getExtension().getMinecraftVersion().map(minecraftVersion -> this.getExtension().getMinecraftProvider().getVersionInfo().assetIndex().fabricId((String)minecraftVersion)));
        this.getAssetsDir().set(new File(this.getExtension().getFiles().getUserCache(), "assets"));
        this.getMainClass().convention((Object)"net.fabricmc.loader.impl.launch.knot.KnotClient");
        this.getClasspath().from(new Object[]{this.getExtension().getMinecraftProvider().getMinecraftClientJar()});
        this.getClasspath().from(new Object[]{this.detachedConfigurationProvider("net.fabricmc:fabric-loader:%s", this.getProjectLoaderVersion())});
        this.getClasspath().from(new Object[]{this.detachedConfigurationProvider("net.fabricmc:intermediary:%s", this.getExtension().getMinecraftVersion())});
        this.getClasspath().from(new Object[]{this.getProject().getConfigurations().named("minecraftTestClientRuntimeLibraries")});
        this.dependsOn(new Object[]{"downloadAssets"});
    }

    @Override
    protected void configureCommand(ExecSpec exec) {
        if (((Boolean)this.getUseXVFB().get()).booleanValue()) {
            if (!Platform.CURRENT.getOperatingSystem().isLinux()) {
                throw new UnsupportedOperationException("XVFB is only supported on Linux");
            }
            exec.commandLine(new Object[]{"/usr/bin/xvfb-run"});
            exec.args(new Object[]{"-a", ((JavaLauncher)this.getJavaLauncher().get()).getExecutablePath()});
            return;
        }
        super.configureCommand(exec);
    }

    @Override
    protected void configureJvmArgs(ExecSpec exec) {
        super.configureJvmArgs(exec);
        if (Platform.CURRENT.getOperatingSystem().isMacOS()) {
            exec.args(new Object[]{"-XstartOnFirstThread"});
        }
    }

    @Override
    protected void configureProgramArgs(ExecSpec exec) {
        super.configureProgramArgs(exec);
        exec.args(new Object[]{"--assetIndex", this.getAssetsIndex().get(), "--assetsDir", ((Directory)this.getAssetsDir().get()).getAsFile().getAbsolutePath(), "--gameDir", ((Directory)this.getRunDir().get()).getAsFile().getAbsolutePath()});
    }
}

