/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.util.download;

import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import net.fabricmc.loom.util.download.DownloadException;

public class DownloadExecutor
implements AutoCloseable {
    private final ExecutorService executorService;
    private final List<DownloadException> downloadExceptions = Collections.synchronizedList(new ArrayList());

    public DownloadExecutor(int threads) {
        this.executorService = Executors.newFixedThreadPool(threads);
    }

    void runAsync(DownloadRunner downloadRunner) {
        if (!this.downloadExceptions.isEmpty()) {
            return;
        }
        this.executorService.execute(() -> {
            try {
                downloadRunner.run();
            }
            catch (DownloadException e) {
                this.executorService.shutdownNow();
                this.downloadExceptions.add(e);
                throw new UncheckedIOException(e);
            }
        });
    }

    @Override
    public void close() throws DownloadException {
        this.executorService.shutdown();
        try {
            this.executorService.awaitTermination(1L, TimeUnit.DAYS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        if (!this.downloadExceptions.isEmpty()) {
            DownloadException downloadException = new DownloadException("Failed to download");
            for (DownloadException suppressed : this.downloadExceptions) {
                downloadException.addSuppressed(suppressed);
            }
            throw downloadException;
        }
    }

    @FunctionalInterface
    public static interface DownloadRunner {
        public void run() throws DownloadException;
    }
}

