/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.fabricapi;

import java.io.IOException;
import javax.inject.Inject;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.util.fmj.FabricModJson;
import net.fabricmc.loom.util.fmj.FabricModJsonFactory;
import net.fabricmc.loom.util.gradle.SourceSetHelper;
import org.gradle.api.Project;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.file.FileCollection;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;

abstract class FabricApiAbstractSourceSet {
    FabricApiAbstractSourceSet() {
    }

    @Inject
    protected abstract Project getProject();

    protected abstract String getSourceSetName();

    protected void configureSourceSet(Property<String> modId, boolean isClient) {
        LoomGradleExtension extension = LoomGradleExtension.get(this.getProject());
        SourceSet mainSourceSet = SourceSetHelper.getMainSourceSet(this.getProject());
        boolean isClientAndSplit = extension.areEnvironmentSourceSetsSplit() && isClient;
        SourceSetContainer sourceSets = SourceSetHelper.getSourceSets(this.getProject());
        SourceSet dataGenSourceSet = (SourceSet)sourceSets.create(this.getSourceSetName(), sourceSet -> {
            this.dependsOn((SourceSet)sourceSet, mainSourceSet);
            if (isClientAndSplit) {
                this.dependsOn((SourceSet)sourceSet, SourceSetHelper.getSourceSetByName("client", this.getProject()));
            }
        });
        modId.convention(this.getProject().provider(() -> {
            try {
                FabricModJson fabricModJson = FabricModJsonFactory.createFromSourceSetsNullable(this.getProject(), dataGenSourceSet);
                if (fabricModJson == null) {
                    throw new RuntimeException("Could not find a fabric.mod.json file in the data source set or a value for DataGenerationSettings.getModId()");
                }
                return fabricModJson.getId();
            }
            catch (IOException e) {
                throw new UncheckedIOException("Failed to read mod id from the datagen source set.", (Throwable)e);
            }
        }));
        extension.getMods().create((String)modId.get(), mod -> mod.sourceSet(this.getSourceSetName()));
        extension.createRemapConfigurations((SourceSet)sourceSets.getByName(this.getSourceSetName()));
    }

    private static void extendsFrom(Project project, String name, String extendsFrom) {
        ConfigurationContainer configurations = project.getConfigurations();
        configurations.named(name, configuration -> configuration.extendsFrom(new Configuration[]{configurations.getByName(extendsFrom)}));
    }

    private void dependsOn(SourceSet sourceSet, SourceSet other) {
        sourceSet.setCompileClasspath(sourceSet.getCompileClasspath().plus((FileCollection)other.getOutput()));
        sourceSet.setRuntimeClasspath(sourceSet.getRuntimeClasspath().plus((FileCollection)other.getOutput()));
        FabricApiAbstractSourceSet.extendsFrom(this.getProject(), sourceSet.getCompileClasspathConfigurationName(), other.getCompileClasspathConfigurationName());
        FabricApiAbstractSourceSet.extendsFrom(this.getProject(), sourceSet.getRuntimeClasspathConfigurationName(), other.getRuntimeClasspathConfigurationName());
    }
}

