/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.util;

import java.util.Objects;
import net.fabricmc.mappingio.tree.MemoryMappingTree;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.RecordComponentVisitor;

public class RecordComponentFixVisitor
extends ClassVisitor {
    private final MemoryMappingTree mappings;
    private final int intermediaryNsId;
    private String owner;
    private boolean hasExistingComponents = false;

    public RecordComponentFixVisitor(ClassVisitor classVisitor, MemoryMappingTree mappings, int intermediaryNsId) {
        super(589824, classVisitor);
        this.mappings = mappings;
        this.intermediaryNsId = intermediaryNsId;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.owner = name;
        super.visit(version, access, name, signature, superName, interfaces);
    }

    public RecordComponentVisitor visitRecordComponent(String name, String descriptor, String signature) {
        this.hasExistingComponents = true;
        return super.visitRecordComponent(name, descriptor, signature);
    }

    public FieldVisitor visitField(int access, String name, String descriptor, String signature, Object value) {
        String intermediaryName = Objects.requireNonNull(this.mappings.getField(this.owner, name, descriptor), "Could not get field for %s:%s%s".formatted(this.owner, name, descriptor)).getName(this.intermediaryNsId);
        if (!this.hasExistingComponents && intermediaryName != null && intermediaryName.startsWith("comp_")) {
            super.visitRecordComponent(name, descriptor, signature);
        }
        return super.visitField(access, name, descriptor, signature, value);
    }
}

