/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.providers.mappings;

import com.google.common.base.Suppliers;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collections;
import java.util.function.Supplier;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.api.mappings.intermediate.IntermediateMappingsProvider;
import net.fabricmc.loom.api.mappings.layered.MappingsNamespace;
import net.fabricmc.loom.configuration.providers.mappings.IntermediateMappingsProviderInternal;
import net.fabricmc.loom.configuration.providers.minecraft.MinecraftProvider;
import net.fabricmc.loom.util.service.Service;
import net.fabricmc.loom.util.service.ServiceFactory;
import net.fabricmc.loom.util.service.ServiceType;
import net.fabricmc.mappingio.MappingVisitor;
import net.fabricmc.mappingio.adapter.MappingNsCompleter;
import net.fabricmc.mappingio.format.tiny.Tiny2FileReader;
import net.fabricmc.mappingio.tree.MemoryMappingTree;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.jetbrains.annotations.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IntermediateMappingsService
extends Service<Options> {
    public static final ServiceType<Options, IntermediateMappingsService> TYPE = new ServiceType<Options, IntermediateMappingsService>(Options.class, IntermediateMappingsService.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(IntermediateMappingsService.class);
    private final Supplier<MemoryMappingTree> memoryMappingTree = Suppliers.memoize(this::createMemoryMappingTree);

    public IntermediateMappingsService(Options options, ServiceFactory serviceFactory) {
        super(options, serviceFactory);
    }

    public static Provider<Options> createOptions(Project project, MinecraftProvider minecraftProvider) {
        LoomGradleExtension extension = LoomGradleExtension.get(project);
        IntermediateMappingsProvider intermediateProvider = extension.getIntermediateMappingsProvider();
        Path intermediaryTiny = minecraftProvider.file(intermediateProvider.getName() + ".tiny").toPath();
        try {
            if (intermediateProvider instanceof IntermediateMappingsProviderInternal) {
                IntermediateMappingsProviderInternal internal = (IntermediateMappingsProviderInternal)intermediateProvider;
                internal.provide(intermediaryTiny, project);
            } else {
                intermediateProvider.provide(intermediaryTiny);
            }
        }
        catch (IOException e) {
            try {
                Files.deleteIfExists(intermediaryTiny);
            }
            catch (IOException ex) {
                LOGGER.warn("Failed to delete intermediary mappings file", (Throwable)ex);
            }
            throw new UncheckedIOException("Failed to provide intermediate mappings", e);
        }
        return IntermediateMappingsService.createOptions(project, minecraftProvider, intermediaryTiny);
    }

    private static Provider<Options> createOptions(Project project, MinecraftProvider minecraftProvider, Path intermediaryTiny) {
        LoomGradleExtension extension = LoomGradleExtension.get(project);
        IntermediateMappingsProvider intermediateProvider = extension.getIntermediateMappingsProvider();
        String expectedSrcNs = minecraftProvider.isLegacyVersion() ? MappingsNamespace.INTERMEDIARY.toString() : MappingsNamespace.OFFICIAL.toString();
        return TYPE.create(project, (Action<Options>)((Action)options -> {
            options.getIntermediaryTiny().set(intermediaryTiny.toFile());
            options.getExpectedSrcNs().set((Object)expectedSrcNs);
            options.getMinecraftVersion().set(intermediateProvider.getMinecraftVersion());
        }));
    }

    private MemoryMappingTree createMemoryMappingTree() {
        return IntermediateMappingsService.createMemoryMappingTree(this.getIntermediaryTiny(), (String)((Options)this.getOptions()).getExpectedSrcNs().get());
    }

    @VisibleForTesting
    public static MemoryMappingTree createMemoryMappingTree(Path mappingFile, String expectedSrcNs) {
        MemoryMappingTree tree = new MemoryMappingTree();
        try {
            MappingNsCompleter nsCompleter = new MappingNsCompleter((MappingVisitor)tree, Collections.singletonMap(MappingsNamespace.NAMED.toString(), MappingsNamespace.INTERMEDIARY.toString()), true);
            try (BufferedReader reader = Files.newBufferedReader(mappingFile, StandardCharsets.UTF_8);){
                Tiny2FileReader.read((Reader)reader, (MappingVisitor)nsCompleter);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to read intermediary mappings", e);
        }
        if (!expectedSrcNs.equals(tree.getSrcNamespace())) {
            throw new RuntimeException("Invalid intermediate mappings: expected source namespace '" + expectedSrcNs + "' but found '" + tree.getSrcNamespace() + "'");
        }
        return tree;
    }

    public MemoryMappingTree getMemoryMappingTree() {
        return this.memoryMappingTree.get();
    }

    public Path getIntermediaryTiny() {
        return ((RegularFile)((Options)this.getOptions()).getIntermediaryTiny().get()).getAsFile().toPath();
    }

    public static interface Options
    extends Service.Options {
        @InputFile
        public RegularFileProperty getIntermediaryTiny();

        @Input
        public Property<String> getExpectedSrcNs();

        @Input
        public Property<String> getMinecraftVersion();
    }
}

