/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.accesswidener;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.List;
import net.fabricmc.accesswidener.AccessWidenerReader;
import net.fabricmc.accesswidener.AccessWidenerVisitor;
import net.fabricmc.loom.api.mappings.layered.MappingsNamespace;
import net.fabricmc.loom.api.processor.MappingProcessorContext;
import net.fabricmc.loom.api.processor.MinecraftJarProcessor;
import net.fabricmc.loom.configuration.accesswidener.AccessWidenerEntry;
import net.fabricmc.loom.configuration.accesswidener.AccessWidenerJarProcessor;
import net.fabricmc.loom.util.LazyCloseable;
import net.fabricmc.mappingio.tree.MappingTree;
import net.fabricmc.mappingio.tree.MemoryMappingTree;
import net.fabricmc.tinyremapper.TinyRemapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TransitiveAccessWidenerMappingsProcessor
implements MinecraftJarProcessor.MappingsProcessor<AccessWidenerJarProcessor.Spec> {
    public static final TransitiveAccessWidenerMappingsProcessor INSTANCE = new TransitiveAccessWidenerMappingsProcessor();

    private TransitiveAccessWidenerMappingsProcessor() {
    }

    @Override
    public boolean transform(MemoryMappingTree mappings, AccessWidenerJarProcessor.Spec spec, MappingProcessorContext context) {
        List<AccessWidenerEntry> accessWideners = spec.accessWideners().stream().filter(entry -> entry.mappingId() != null).toList();
        if (accessWideners.isEmpty()) {
            return false;
        }
        if (!MappingsNamespace.INTERMEDIARY.toString().equals(mappings.getSrcNamespace())) {
            throw new IllegalStateException("Mapping tree must have intermediary src mappings not " + mappings.getSrcNamespace());
        }
        try (LazyCloseable<TinyRemapper> remapper = context.createRemapper(MappingsNamespace.INTERMEDIARY, MappingsNamespace.NAMED);){
            for (AccessWidenerEntry accessWidener : accessWideners) {
                MappingCommentVisitor visitor = new MappingCommentVisitor(accessWidener.mappingId(), mappings);
                accessWidener.read(visitor, remapper);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to transform access widener mappings", e);
        }
        return true;
    }

    private record MappingCommentVisitor(String modId, MemoryMappingTree mappingTree) implements AccessWidenerVisitor
    {
        private static final Logger LOGGER = LoggerFactory.getLogger(MappingCommentVisitor.class);

        public void visitClass(String name, AccessWidenerReader.AccessType access, boolean transitive) {
            MappingTree.ClassMapping classMapping = this.mappingTree.getClass(name);
            if (classMapping == null) {
                LOGGER.info("Failed to find class ({}) to mark access widened by mod ({})", (Object)name, (Object)this.modId());
                return;
            }
            classMapping.setComment(this.appendComment(classMapping.getComment(), access));
        }

        public void visitMethod(String owner, String name, String descriptor, AccessWidenerReader.AccessType access, boolean transitive) {
            this.visitClass(owner, access, transitive);
            MappingTree.ClassMapping classMapping = this.mappingTree.getClass(owner);
            if (classMapping == null) {
                LOGGER.info("Failed to find class ({}) to mark access widened by mod ({})", (Object)owner, (Object)this.modId());
                return;
            }
            MappingTree.MethodMapping methodMapping = classMapping.getMethod(name, descriptor);
            if (methodMapping == null) {
                LOGGER.info("Failed to find method ({}) in ({}) to mark access widened by mod ({})", new Object[]{name, owner, this.modId()});
                return;
            }
            methodMapping.setComment(this.appendComment(methodMapping.getComment(), access));
        }

        public void visitField(String owner, String name, String descriptor, AccessWidenerReader.AccessType access, boolean transitive) {
            this.visitClass(owner, access, transitive);
            MappingTree.ClassMapping classMapping = this.mappingTree.getClass(owner);
            if (classMapping == null) {
                LOGGER.info("Failed to find class ({}) to mark access widened by mod ({})", (Object)name, (Object)this.modId());
                return;
            }
            MappingTree.FieldMapping fieldMapping = classMapping.getField(name, descriptor);
            if (fieldMapping == null) {
                LOGGER.info("Failed to find field ({}) in ({}) to mark access widened by mod ({})", new Object[]{name, owner, this.modId()});
                return;
            }
            fieldMapping.setComment(this.appendComment(fieldMapping.getComment(), access));
        }

        private String appendComment(String comment, AccessWidenerReader.AccessType access) {
            String awComment;
            if (!((String)(comment = comment == null ? "" : (String)comment + "\n")).contains(awComment = "Access widened by %s to %s".formatted(this.modId(), access))) {
                comment = (String)comment + awComment;
            }
            return comment;
        }
    }
}

