/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.task.prod;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import net.fabricmc.loom.configuration.InstallerData;
import net.fabricmc.loom.task.AbstractLoomTask;
import net.fabricmc.loom.util.gradle.GradleUtils;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.UntrackedTask;
import org.gradle.jvm.toolchain.JavaLauncher;
import org.gradle.jvm.toolchain.JavaToolchainService;
import org.gradle.jvm.toolchain.JavaToolchainSpec;
import org.gradle.process.ExecOperations;
import org.gradle.process.ExecResult;
import org.gradle.process.ExecSpec;
import org.jetbrains.annotations.ApiStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@UntrackedTask(because="Always rerun this task.")
@ApiStatus.Experimental
public abstract class AbstractProductionRunTask
extends AbstractLoomTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractProductionRunTask.class);

    @Classpath
    public abstract ConfigurableFileCollection getMods();

    @Input
    public abstract ListProperty<String> getJvmArgs();

    @Input
    public abstract ListProperty<String> getProgramArgs();

    @OutputDirectory
    public abstract DirectoryProperty getRunDir();

    @Nested
    public abstract Property<JavaLauncher> getJavaLauncher();

    @Classpath
    @ApiStatus.Internal
    protected abstract ConfigurableFileCollection getClasspath();

    @Input
    @ApiStatus.Internal
    protected abstract Property<String> getMainClass();

    @Inject
    protected abstract ExecOperations getExecOperations();

    @Inject
    protected abstract JavaToolchainService getJavaToolchainService();

    @Inject
    public AbstractProductionRunTask() {
        JavaToolchainSpec defaultToolchain = ((JavaPluginExtension)this.getProject().getExtensions().getByType(JavaPluginExtension.class)).getToolchain();
        this.getJavaLauncher().convention(this.getJavaToolchainService().launcherFor(defaultToolchain));
        this.getRunDir().convention(this.getProject().getLayout().getProjectDirectory().dir("run"));
        if (!GradleUtils.getBooleanProperty(this.getProject(), "fabric.loom.dontRemap")) {
            this.getMods().from(new Object[]{this.getProject().getTasks().named("remapJar")});
        }
    }

    @TaskAction
    public void run() throws IOException {
        Files.createDirectories(((Directory)this.getRunDir().get()).getAsFile().toPath(), new FileAttribute[0]);
        ExecResult result = this.getExecOperations().exec(exec -> {
            this.configureCommand((ExecSpec)exec);
            this.configureJvmArgs((ExecSpec)exec);
            this.configureClasspath((ExecSpec)exec);
            this.configureMainClass((ExecSpec)exec);
            this.configureProgramArgs((ExecSpec)exec);
            exec.setWorkingDir((Object)this.getRunDir());
            LOGGER.debug("Running command: {}", (Object)exec.getCommandLine());
        });
        result.assertNormalExitValue();
    }

    protected void configureCommand(ExecSpec exec) {
        exec.commandLine(new Object[]{((JavaLauncher)this.getJavaLauncher().get()).getExecutablePath()});
    }

    protected void configureJvmArgs(ExecSpec exec) {
        exec.args((Iterable)this.getJvmArgs().get());
        exec.args(new Object[]{"-Dfabric.addMods=" + AbstractProductionRunTask.joinFiles(this.getMods().getFiles().stream())});
    }

    protected Stream<File> streamClasspath() {
        return this.getClasspath().getFiles().stream();
    }

    protected void configureClasspath(ExecSpec exec) {
        exec.args(new Object[]{"-cp"});
        exec.args(new Object[]{AbstractProductionRunTask.joinFiles(this.streamClasspath())});
    }

    protected void configureMainClass(ExecSpec exec) {
        exec.args(new Object[]{this.getMainClass().get()});
    }

    protected void configureProgramArgs(ExecSpec exec) {
        exec.args((Iterable)this.getProgramArgs().get());
    }

    @Internal
    protected Provider<String> getProjectLoaderVersion() {
        return this.getProject().provider(() -> {
            InstallerData installerData = this.getExtension().getInstallerData();
            if (installerData == null) {
                return null;
            }
            return installerData.version();
        });
    }

    protected Provider<Configuration> detachedConfigurationProvider(String mavenNotation, Provider<String> versionProvider) {
        return versionProvider.map(version -> {
            Dependency serverLauncher = this.getProject().getDependencies().create((Object)mavenNotation.formatted(version));
            return this.getProject().getConfigurations().detachedConfiguration(new Dependency[]{serverLauncher});
        });
    }

    private static String joinFiles(Stream<File> stream) {
        return stream.map(File::getAbsolutePath).collect(Collectors.joining(File.pathSeparator));
    }
}

