/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration;

import java.util.ArrayList;
import javax.inject.Inject;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.util.LoomVersions;
import net.fabricmc.loom.util.gradle.SourceSetHelper;
import org.gradle.api.NamedDomainObjectProvider;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.attributes.Bundling;
import org.gradle.api.attributes.Category;
import org.gradle.api.attributes.HasConfigurableAttributes;
import org.gradle.api.attributes.LibraryElements;
import org.gradle.api.attributes.Usage;

public abstract class LoomConfigurations
implements Runnable {
    @Inject
    protected abstract Project getProject();

    @Inject
    protected abstract ConfigurationContainer getConfigurations();

    @Inject
    protected abstract DependencyHandler getDependencies();

    @Override
    public void run() {
        LoomGradleExtension extension = LoomGradleExtension.get(this.getProject());
        this.register("modCompileClasspath", Role.RESOLVABLE);
        this.registerNonTransitive("modCompileClasspathMapped", Role.RESOLVABLE);
        NamedDomainObjectProvider<Configuration> minecraftClientCompile = this.registerNonTransitive("minecraftClientLibraries", Role.RESOLVABLE);
        NamedDomainObjectProvider<Configuration> minecraftServerCompile = this.registerNonTransitive("minecraftServerLibraries", Role.RESOLVABLE);
        NamedDomainObjectProvider<Configuration> minecraftCompile = this.registerNonTransitive("minecraftLibraries", Role.RESOLVABLE);
        minecraftCompile.configure(configuration -> {
            configuration.extendsFrom(new Configuration[]{(Configuration)minecraftClientCompile.get()});
            configuration.extendsFrom(new Configuration[]{(Configuration)minecraftServerCompile.get()});
        });
        NamedDomainObjectProvider<Configuration> minecraftClientRuntime = this.registerNonTransitive("minecraftClientRuntimeLibraries", Role.RESOLVABLE);
        NamedDomainObjectProvider<Configuration> minecraftServerRuntime = this.registerNonTransitive("minecraftServerRuntimeLibraries", Role.RESOLVABLE);
        minecraftClientRuntime.configure(configuration -> configuration.extendsFrom(new Configuration[]{(Configuration)minecraftClientCompile.get()}));
        minecraftServerRuntime.configure(configuration -> configuration.extendsFrom(new Configuration[]{(Configuration)minecraftServerCompile.get()}));
        this.registerNonTransitive("minecraftRuntimeLibraries", Role.RESOLVABLE).configure(minecraftRuntime -> {
            minecraftRuntime.extendsFrom(new Configuration[]{(Configuration)minecraftClientRuntime.get()});
            minecraftRuntime.extendsFrom(new Configuration[]{(Configuration)minecraftServerRuntime.get()});
        });
        this.registerNonTransitive("minecraftNatives", Role.RESOLVABLE);
        this.registerNonTransitive("loaderLibraries", Role.RESOLVABLE);
        this.registerNonTransitive("minecraft", Role.NONE);
        NamedDomainObjectProvider<Configuration> include = this.register("include", Role.NONE);
        this.register("includeInternal", Role.RESOLVABLE).configure(configuration -> {
            configuration.getDependencies().addAllLater(this.getProject().provider(() -> {
                ArrayList<Object> dependencies = new ArrayList<Object>();
                for (Dependency dependency : ((Configuration)include.get()).getIncoming().getDependencies()) {
                    if (dependency instanceof HasConfigurableAttributes) {
                        HasConfigurableAttributes hasAttributes = (HasConfigurableAttributes)dependency;
                        Category category = (Category)hasAttributes.getAttributes().getAttribute(Category.CATEGORY_ATTRIBUTE);
                        if (category != null && (category.getName().equals("enforced-platform") || category.getName().equals("platform"))) {
                            dependencies.add(dependency);
                            continue;
                        }
                        if (dependency instanceof ModuleDependency) {
                            ModuleDependency moduleDependency = (ModuleDependency)dependency;
                            ModuleDependency copy = moduleDependency.copy();
                            copy.setTransitive(false);
                            dependencies.add(copy);
                            continue;
                        }
                    }
                    dependencies.add(dependency);
                }
                return dependencies;
            }));
            configuration.attributes(attributes -> {
                attributes.attribute(Usage.USAGE_ATTRIBUTE, (Object)((Usage)this.getProject().getObjects().named(Usage.class, "java-runtime")));
                attributes.attribute(LibraryElements.LIBRARY_ELEMENTS_ATTRIBUTE, (Object)((LibraryElements)this.getProject().getObjects().named(LibraryElements.class, "jar")));
                attributes.attribute(Category.CATEGORY_ATTRIBUTE, (Object)((Category)this.getProject().getObjects().named(Category.class, "library")));
                attributes.attribute(Bundling.BUNDLING_ATTRIBUTE, (Object)((Bundling)this.getProject().getObjects().named(Bundling.class, "external")));
            });
        });
        this.registerNonTransitive("mappingsConstants", Role.RESOLVABLE);
        this.register("namedElements", Role.CONSUMABLE).configure(configuration -> configuration.extendsFrom(new Configuration[]{this.getConfigurations().getByName("api")}));
        this.extendsFrom("compileOnly", "mappingsConstants");
        this.register("mappings", Role.RESOLVABLE);
        this.register("mappingsFinal", Role.RESOLVABLE);
        this.register("loomDevelopmentDependencies", Role.RESOLVABLE);
        this.register("unpick", Role.RESOLVABLE);
        this.register("localRuntime", Role.RESOLVABLE);
        this.extendsFrom("runtimeClasspath", "localRuntime");
        extension.createRemapConfigurations(SourceSetHelper.getMainSourceSet(this.getProject()));
        this.extendsFrom("runtimeClasspath", "mappingsFinal");
        this.extendsFrom("testRuntimeClasspath", "mappingsFinal");
        this.extendsFrom("runtimeClasspath", "minecraftRuntimeLibraries");
        this.getDependencies().add("loomDevelopmentDependencies", (Object)LoomVersions.DEV_LAUNCH_INJECTOR.mavenNotation());
        this.getDependencies().add("loomDevelopmentDependencies", (Object)LoomVersions.TERMINAL_CONSOLE_APPENDER.mavenNotation());
        this.getDependencies().add("compileOnly", (Object)LoomVersions.JETBRAINS_ANNOTATIONS.mavenNotation());
        this.getDependencies().add("testCompileOnly", (Object)LoomVersions.JETBRAINS_ANNOTATIONS.mavenNotation());
        this.register("minecraftTestClientRuntimeLibraries", Role.RESOLVABLE);
        this.extendsFrom("minecraftTestClientRuntimeLibraries", "minecraftNatives");
        this.extendsFrom("minecraftTestClientRuntimeLibraries", "minecraftClientRuntimeLibraries");
        this.extendsFrom("minecraftTestClientRuntimeLibraries", "loaderLibraries");
    }

    private NamedDomainObjectProvider<Configuration> register(String name, Role role) {
        return this.getConfigurations().register(name, role::apply);
    }

    private NamedDomainObjectProvider<Configuration> registerNonTransitive(String name, Role role) {
        NamedDomainObjectProvider<Configuration> provider = this.register(name, role);
        provider.configure(configuration -> configuration.setTransitive(false));
        return provider;
    }

    public void extendsFrom(String a, String b) {
        this.getConfigurations().getByName(a, configuration -> configuration.extendsFrom(new Configuration[]{this.getConfigurations().getByName(b)}));
    }

    static enum Role {
        NONE(false, false),
        CONSUMABLE(true, false),
        RESOLVABLE(false, true);

        private final boolean canBeConsumed;
        private final boolean canBeResolved;

        private Role(boolean canBeConsumed, boolean canBeResolved) {
            this.canBeConsumed = canBeConsumed;
            this.canBeResolved = canBeResolved;
        }

        void apply(Configuration configuration) {
            configuration.setCanBeConsumed(this.canBeConsumed);
            configuration.setCanBeResolved(this.canBeResolved);
        }
    }
}

