/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.providers.mappings.utils;

import java.io.File;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Objects;
import net.fabricmc.loom.api.mappings.layered.MappingContext;
import net.fabricmc.loom.api.mappings.layered.spec.FileSpec;
import net.fabricmc.loom.util.Checksum;

public class LocalFileSpec
implements FileSpec {
    private final File file;
    private final int hash;

    public LocalFileSpec(File file) {
        this.file = file;
        this.hash = this.calculateHashCode();
    }

    private int calculateHashCode() {
        if (!this.file.exists()) {
            throw new RuntimeException("Could not find %s, it must be present at spec creation time to calculate mappings hash".formatted(this.file.getAbsolutePath()));
        }
        return Objects.hash(Arrays.hashCode(Checksum.sha256(this.file)), this.file.getAbsolutePath());
    }

    @Override
    public Path get(MappingContext context) {
        return this.file.toPath();
    }

    public int hashCode() {
        return this.hash;
    }
}

