/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.extension;

import java.lang.reflect.Constructor;
import javax.inject.Inject;
import net.fabricmc.loom.api.remapping.RemapperContext;
import net.fabricmc.loom.api.remapping.RemapperExtension;
import net.fabricmc.loom.api.remapping.RemapperParameters;
import net.fabricmc.loom.api.remapping.TinyRemapperExtension;
import net.fabricmc.tinyremapper.TinyRemapper;
import net.fabricmc.tinyremapper.api.TrClass;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.commons.Remapper;

public abstract class RemapperExtensionHolder {
    @Inject
    public RemapperExtensionHolder(RemapperParameters remapperParameters) {
        this.getRemapperParameters().set((Object)remapperParameters);
    }

    @Input
    public abstract Property<String> getRemapperExtensionClass();

    @Optional
    public abstract Property<RemapperParameters> getRemapperParameters();

    public void apply(TinyRemapper.Builder tinyRemapperBuilder, String sourceNamespace, String targetNamespace) {
        RemapperExtension<?> remapperExtension = this.newInstance();
        tinyRemapperBuilder.extraPostApplyVisitor((TinyRemapper.ApplyVisitorProvider)new RemapperExtensionImpl(remapperExtension, sourceNamespace, targetNamespace));
        if (remapperExtension instanceof TinyRemapperExtension) {
            TinyRemapperExtension tinyRemapperExtension = (TinyRemapperExtension)((Object)remapperExtension);
            TinyRemapperContextImpl context = new TinyRemapperContextImpl(sourceNamespace, targetNamespace);
            TinyRemapper.AnalyzeVisitorProvider analyzeVisitorProvider = tinyRemapperExtension.getAnalyzeVisitorProvider(context);
            TinyRemapper.ApplyVisitorProvider preApplyVisitorProvider = tinyRemapperExtension.getPreApplyVisitor(context);
            TinyRemapper.ApplyVisitorProvider postApplyVisitorProvider = tinyRemapperExtension.getPostApplyVisitor(context);
            if (analyzeVisitorProvider != null) {
                tinyRemapperBuilder.extraAnalyzeVisitor(analyzeVisitorProvider);
            }
            if (preApplyVisitorProvider != null) {
                tinyRemapperBuilder.extraPreApplyVisitor(preApplyVisitorProvider);
            }
            if (postApplyVisitorProvider != null) {
                tinyRemapperBuilder.extraPostApplyVisitor(postApplyVisitorProvider);
            }
        }
    }

    private RemapperExtension<?> newInstance() {
        try {
            Class<?> remapperExtensionClass = Class.forName((String)this.getRemapperExtensionClass().get());
            Constructor<?> constructor = RemapperExtensionHolder.getInjectedConstructor(remapperExtensionClass);
            if (this.getRemapperParameters().get() instanceof RemapperParameters.None) {
                return (RemapperExtension)constructor.newInstance(new Object[0]);
            }
            return (RemapperExtension)constructor.newInstance(this.getRemapperParameters().get());
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create remapper extension for class: " + (String)this.getRemapperExtensionClass().get(), e);
        }
    }

    private static Constructor<?> getInjectedConstructor(Class<?> clazz) {
        Constructor<?>[] constructors = clazz.getConstructors();
        Constructor<?> injectedConstructor = null;
        for (Constructor<?> constructor : constructors) {
            if (injectedConstructor != null) {
                throw new RuntimeException("RemapperExtension class " + clazz.getName() + " has more than one constructor");
            }
            injectedConstructor = constructor;
        }
        if (injectedConstructor == null) {
            throw new RuntimeException("RemapperExtension class " + clazz.getName() + " does not have a constructor");
        }
        return injectedConstructor;
    }

    private static final class RemapperExtensionImpl
    implements TinyRemapper.ApplyVisitorProvider {
        private final RemapperExtension<?> remapperExtension;
        private final String sourceNamespace;
        private final String targetNamespace;
        @Nullable
        private RemapperContext context;

        private RemapperExtensionImpl(RemapperExtension<?> remapperExtension, String sourceNamespace, String targetNamespace) {
            this.remapperExtension = remapperExtension;
            this.sourceNamespace = sourceNamespace;
            this.targetNamespace = targetNamespace;
        }

        public ClassVisitor insertApplyVisitor(TrClass cls, ClassVisitor next) {
            if (this.context == null) {
                this.context = new RemapperContextImpl((Remapper)cls.getEnvironment().getRemapper(), this.sourceNamespace, this.targetNamespace);
            }
            return this.remapperExtension.insertVisitor(cls.getName(), this.context, next);
        }
    }

    private record TinyRemapperContextImpl(String sourceNamespace, String targetNamespace) implements TinyRemapperExtension.Context
    {
    }

    private record RemapperContextImpl(Remapper remapper, String sourceNamespace, String targetNamespace) implements RemapperContext
    {
    }
}

