/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.build.mixin;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.build.mixin.AnnotationProcessorInvoker;
import net.fabricmc.loom.extension.MixinExtension;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.compile.GroovyCompile;

public class GroovyApInvoker
extends AnnotationProcessorInvoker<GroovyCompile> {
    public GroovyApInvoker(Project project) {
        super(project, (Collection<Configuration>)ImmutableList.of(), GroovyApInvoker.getInvokerTasks(project), "groovy");
    }

    private static Map<SourceSet, GroovyCompile> getInvokerTasks(Project project) {
        MixinExtension mixin = LoomGradleExtension.get(project).getMixin();
        return mixin.getInvokerTasksStream("groovy").collect(Collectors.toMap(Map.Entry::getKey, entry -> Objects.requireNonNull((GroovyCompile)entry.getValue())));
    }

    @Override
    protected void passArgument(GroovyCompile compileTask, String key, String value) {
        compileTask.getOptions().getCompilerArgs().add("-A" + key + "=" + value);
    }

    @Override
    protected File getRefmapDestinationDir(GroovyCompile task) {
        return (File)task.getDestinationDirectory().getAsFile().get();
    }
}

