/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.task;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import javax.inject.Inject;
import net.fabricmc.loom.task.AbstractRemapJarTask;
import net.fabricmc.loom.task.service.ClientEntriesService;
import net.fabricmc.loom.task.service.SourceRemapperService;
import net.fabricmc.loom.util.service.ScopedServiceFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RemapSourcesJarTask
extends AbstractRemapJarTask {
    @Nested
    abstract Property<SourceRemapperService.Options> getSourcesRemapperServiceOptions();

    @Inject
    public RemapSourcesJarTask() {
        this.getClasspath().from(new Object[]{this.getProject().getConfigurations().getByName("compileClasspath")});
        this.getJarType().set((Object)"sources");
        this.getSourcesRemapperServiceOptions().set(SourceRemapperService.createOptions(this));
    }

    @TaskAction
    public void run() {
        this.submitWork(RemapSourcesAction.class, params -> {
            if (!params.namespacesMatch()) {
                params.getSourcesRemapperServiceOptions().set(this.getSourcesRemapperServiceOptions());
            }
        });
    }

    @Override
    protected Provider<? extends ClientEntriesService.Options> getClientOnlyEntriesOptionsProvider(SourceSet clientSourceSet) {
        return ClientEntriesService.Source.createOptions(this.getProject(), clientSourceSet);
    }

    public static abstract class RemapSourcesAction
    extends AbstractRemapJarTask.AbstractRemapAction<RemapSourcesParams> {
        private static final Logger LOGGER = LoggerFactory.getLogger(RemapSourcesAction.class);

        public void execute() {
            try {
                if (!((RemapSourcesParams)this.getParameters()).namespacesMatch()) {
                    try (ScopedServiceFactory serviceFactory = new ScopedServiceFactory();){
                        SourceRemapperService sourceRemapperService = (SourceRemapperService)serviceFactory.get(((RemapSourcesParams)this.getParameters()).getSourcesRemapperServiceOptions());
                        sourceRemapperService.remapSourcesJar(this.inputFile, this.outputFile);
                    }
                } else {
                    Files.copy(this.inputFile, this.outputFile, StandardCopyOption.REPLACE_EXISTING);
                }
                this.modifyJarManifest();
                this.rewriteJar();
            }
            catch (Exception e) {
                try {
                    Files.deleteIfExists(this.outputFile);
                }
                catch (IOException ex) {
                    LOGGER.error("Failed to delete output file", (Throwable)ex);
                }
                throw new RuntimeException("Failed to remap sources", e);
            }
        }
    }

    public static interface RemapSourcesParams
    extends AbstractRemapJarTask.AbstractRemapParams {
        public Property<SourceRemapperService.Options> getSourcesRemapperServiceOptions();
    }
}

