/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.decompilers;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Map;
import javax.inject.Inject;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.api.decompilers.DecompilationMetadata;
import net.fabricmc.loom.api.decompilers.LoomDecompiler;
import net.fabricmc.loom.decompilers.LoomInternalDecompiler;
import net.fabricmc.loom.decompilers.cfr.LoomCFRDecompiler;
import net.fabricmc.loom.decompilers.fernflower.FabricFernFlowerDecompiler;
import net.fabricmc.loom.decompilers.vineflower.VineflowerDecompiler;
import net.fabricmc.loom.util.LoomVersions;
import net.fabricmc.loom.util.ZipUtils;
import org.gradle.api.NamedDomainObjectProvider;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DecompilerConfiguration
implements Runnable {
    @Inject
    protected abstract Project getProject();

    @Override
    public void run() {
        NamedDomainObjectProvider<Configuration> fernflowerConfiguration = this.createConfiguration("fernflower", LoomVersions.FERNFLOWER);
        NamedDomainObjectProvider<Configuration> cfrConfiguration = this.createConfiguration("cfr", LoomVersions.CFR);
        NamedDomainObjectProvider<Configuration> vineflowerConfiguration = this.createConfiguration("vineflower", LoomVersions.VINEFLOWER);
        this.registerDecompiler(this.getProject(), "fernFlower", BuiltinFernflower.class, fernflowerConfiguration);
        this.registerDecompiler(this.getProject(), "cfr", BuiltinCfr.class, cfrConfiguration);
        this.registerDecompiler(this.getProject(), "vineflower", BuiltinVineflower.class, vineflowerConfiguration);
    }

    private NamedDomainObjectProvider<Configuration> createConfiguration(String name, LoomVersions version) {
        String configurationName = name + "DecompilerClasspath";
        NamedDomainObjectProvider configuration = this.getProject().getConfigurations().register(configurationName);
        this.getProject().getDependencies().add(configurationName, (Object)version.mavenNotation());
        return configuration;
    }

    private void registerDecompiler(Project project, String name, Class<? extends LoomDecompiler> decompilerClass, NamedDomainObjectProvider<Configuration> configuration) {
        LoomGradleExtension.get(project).getDecompilerOptions().register(name, options -> {
            options.getDecompilerClassName().set((Object)decompilerClass.getName());
            options.getClasspath().from(new Object[]{configuration});
        });
    }

    public static final class BuiltinFernflower
    extends BuiltinDecompiler {
        public BuiltinFernflower() {
            super(new FabricFernFlowerDecompiler());
        }
    }

    public static final class BuiltinCfr
    extends BuiltinDecompiler {
        public BuiltinCfr() {
            super(new LoomCFRDecompiler());
        }
    }

    public static final class BuiltinVineflower
    extends BuiltinDecompiler {
        public BuiltinVineflower() {
            super(new VineflowerDecompiler());
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static abstract class BuiltinDecompiler
    implements LoomDecompiler {
        private final LoomInternalDecompiler internalDecompiler;

        BuiltinDecompiler(LoomInternalDecompiler internalDecompiler) {
            this.internalDecompiler = internalDecompiler;
        }

        @Override
        public void decompile(final Path compiledJar, final Path sourcesDestination, final Path linemapDestination, final DecompilationMetadata metaData) {
            final Logger slf4jLogger = LoggerFactory.getLogger(this.internalDecompiler.getClass());
            LoomInternalDecompiler.Logger logger = new LoomInternalDecompiler.Logger(){

                @Override
                public void accept(String data) throws IOException {
                    metaData.logger().accept(data);
                }

                @Override
                public void error(String msg) {
                    slf4jLogger.error(msg);
                }
            };
            this.internalDecompiler.decompile(new LoomInternalDecompiler.Context(){
                final /* synthetic */ 1 val$logger;
                {
                    this.val$logger = var6_6;
                }

                @Override
                public Path compiledJar() {
                    return compiledJar;
                }

                @Override
                public Path sourcesDestination() {
                    return sourcesDestination;
                }

                @Override
                public Path linemapDestination() {
                    return linemapDestination;
                }

                @Override
                public int numberOfThreads() {
                    return metaData.numberOfThreads();
                }

                @Override
                public Path javaDocs() {
                    return metaData.javaDocs();
                }

                @Override
                public Collection<Path> libraries() {
                    return metaData.libraries();
                }

                @Override
                public LoomInternalDecompiler.Logger logger() {
                    return this.val$logger;
                }

                @Override
                public Map<String, String> options() {
                    return metaData.options();
                }

                @Override
                public byte[] unpackZip(Path zip, String path) throws IOException {
                    return ZipUtils.unpack(zip, path);
                }
            });
        }
    }
}

