/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.providers.minecraft.library.processors;

import java.util.function.Consumer;
import java.util.function.Predicate;
import net.fabricmc.loom.LoomRepositoryPlugin;
import net.fabricmc.loom.configuration.providers.minecraft.library.Library;
import net.fabricmc.loom.configuration.providers.minecraft.library.LibraryContext;
import net.fabricmc.loom.configuration.providers.minecraft.library.LibraryProcessor;
import net.fabricmc.loom.util.Platform;
import org.gradle.api.artifacts.dsl.RepositoryHandler;

public class ArmNativesLibraryProcessor
extends LibraryProcessor {
    private static final String LWJGL_GROUP = "org.lwjgl";

    public ArmNativesLibraryProcessor(Platform platform, LibraryContext context) {
        super(platform, context);
    }

    @Override
    public LibraryProcessor.ApplicationResult getApplicationResult() {
        if (!this.context.usesLWJGL3()) {
            return LibraryProcessor.ApplicationResult.DONT_APPLY;
        }
        if (!this.platform.getArchitecture().isArm() || !this.platform.getArchitecture().is64Bit()) {
            return LibraryProcessor.ApplicationResult.DONT_APPLY;
        }
        if (this.context.supportsArm64(this.platform.getOperatingSystem())) {
            return LibraryProcessor.ApplicationResult.DONT_APPLY;
        }
        if (this.platform.getOperatingSystem().isMacOS()) {
            return LibraryProcessor.ApplicationResult.MUST_APPLY;
        }
        if (!this.context.hasClasspathNatives()) {
            return LibraryProcessor.ApplicationResult.DONT_APPLY;
        }
        return LibraryProcessor.ApplicationResult.MUST_APPLY;
    }

    @Override
    public Predicate<Library> apply(Consumer<Library> dependencyConsumer) {
        String osName = switch (this.platform.getOperatingSystem()) {
            default -> throw new IncompatibleClassChangeError();
            case Platform.OperatingSystem.MAC_OS -> "macos";
            case Platform.OperatingSystem.WINDOWS -> "windows";
            case Platform.OperatingSystem.LINUX -> "linux";
        };
        return library -> {
            if (library.is(LWJGL_GROUP) && library.target() == Library.Target.NATIVES && library.classifier() != null && library.classifier().equals("natives-" + osName)) {
                dependencyConsumer.accept(library.withClassifier(library.classifier() + "-arm64"));
                if (!this.context.hasClasspathNatives()) {
                    return false;
                }
            }
            return true;
        };
    }

    @Override
    public void applyRepositories(RepositoryHandler repositories) {
        LoomRepositoryPlugin.forceLWJGLFromMavenCentral(repositories);
    }
}

