/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.providers.minecraft.verify;

import com.google.common.base.Suppliers;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import net.fabricmc.loom.LoomGradlePlugin;

public record KnownVersions(Map<String, String> client, Map<String, String> server) {
    public static final Supplier<KnownVersions> INSTANCE = Suppliers.memoize(KnownVersions::load);

    /*
     * Enabled aggressive exception aggregation
     */
    private static KnownVersions load() {
        try (InputStream is = KnownVersions.class.getClassLoader().getResourceAsStream("certs/known_versions.json");){
            KnownVersions knownVersions;
            try (InputStreamReader reader = new InputStreamReader(Objects.requireNonNull(is));){
                knownVersions = (KnownVersions)LoomGradlePlugin.GSON.fromJson((Reader)reader, KnownVersions.class);
            }
            return knownVersions;
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to load known versions", e);
        }
    }
}

