/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.mods.dependency;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Optional;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.configuration.mods.ArtifactMetadata;
import net.fabricmc.loom.configuration.mods.ArtifactRef;
import net.fabricmc.loom.configuration.mods.JarSplitter;
import net.fabricmc.loom.configuration.mods.dependency.ModDependency;
import net.fabricmc.loom.configuration.mods.dependency.SimpleModDependency;
import net.fabricmc.loom.configuration.mods.dependency.SplitModDependency;
import net.fabricmc.loom.util.AttributeHelper;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.jetbrains.annotations.Nullable;

public class ModDependencyFactory {
    private static final String TARGET_ATTRIBUTE_KEY = "loom-target";

    public static ModDependency create(ArtifactRef artifact, ArtifactMetadata metadata, Configuration targetConfig, @Nullable Configuration targetClientConfig, String mappingsSuffix, Project project) {
        if (targetClientConfig != null && ((Boolean)LoomGradleExtension.get(project).getSplitModDependencies().get()).booleanValue()) {
            JarSplitter.Target target;
            Optional<JarSplitter.Target> cachedTarget = ModDependencyFactory.readTarget(artifact);
            if (cachedTarget.isPresent()) {
                target = cachedTarget.get();
            } else {
                target = new JarSplitter(artifact.path()).analyseTarget();
                ModDependencyFactory.writeTarget(artifact, target);
            }
            if (target != null) {
                return new SplitModDependency(artifact, metadata, mappingsSuffix, targetConfig, targetClientConfig, target, project);
            }
        }
        return new SimpleModDependency(artifact, metadata, mappingsSuffix, targetConfig, project);
    }

    private static Optional<JarSplitter.Target> readTarget(ArtifactRef artifact) {
        try {
            return AttributeHelper.readAttribute(artifact.path(), TARGET_ATTRIBUTE_KEY).map(s -> {
                if ("null".equals(s)) {
                    return null;
                }
                return JarSplitter.Target.valueOf(s);
            });
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to read artifact target attribute", e);
        }
    }

    private static void writeTarget(ArtifactRef artifact, JarSplitter.Target target) {
        String value = target != null ? target.name() : "null";
        try {
            AttributeHelper.writeAttribute(artifact.path(), TARGET_ATTRIBUTE_KEY, value);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to write artifact target attribute", e);
        }
    }
}

