/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.util;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.StandardProtocolFamily;
import java.nio.channels.ServerSocketChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import net.fabricmc.loom.util.Platform;

final class CurrentPlatform
implements Platform {
    static final Platform INSTANCE = new CurrentPlatform();
    private final Platform.OperatingSystem operatingSystem = CurrentPlatform.getCurrentOperatingSystem();
    private final Platform.Architecture architecture = CurrentPlatform.getCurrentArchitecture();
    private final boolean supportsUnixDomainSockets = CurrentPlatform.isUnixDomainSocketsSupported();
    private final boolean isRaspberryPi = CurrentPlatform.getIsRaspberryPi(this.operatingSystem, this.architecture);

    private CurrentPlatform() {
    }

    private static Platform.OperatingSystem getCurrentOperatingSystem() {
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.contains("win")) {
            return Platform.OperatingSystem.WINDOWS;
        }
        if (osName.contains("mac")) {
            return Platform.OperatingSystem.MAC_OS;
        }
        return Platform.OperatingSystem.LINUX;
    }

    private static Platform.Architecture getCurrentArchitecture() {
        String arch = System.getProperty("os.arch");
        final boolean is64Bit = arch.contains("64") || arch.startsWith("armv8");
        final boolean isArm = arch.startsWith("arm") || arch.startsWith("aarch64");
        final boolean isRiscV = arch.startsWith("riscv");
        return new Platform.Architecture(){

            @Override
            public boolean is64Bit() {
                return is64Bit;
            }

            @Override
            public boolean isArm() {
                return isArm;
            }

            @Override
            public boolean isRiscV() {
                return isRiscV;
            }
        };
    }

    private static boolean isUnixDomainSocketsSupported() {
        boolean bl;
        block9: {
            ServerSocketChannel serverChannel = ServerSocketChannel.open(StandardProtocolFamily.UNIX);
            try {
                bl = true;
                if (serverChannel == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (serverChannel != null) {
                        try {
                            serverChannel.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (UnsupportedOperationException e) {
                    return false;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            serverChannel.close();
        }
        return bl;
    }

    private static boolean getIsRaspberryPi(Platform.OperatingSystem operatingSystem, Platform.Architecture architecture) {
        if (operatingSystem != Platform.OperatingSystem.LINUX || !architecture.isArm()) {
            return false;
        }
        try {
            Path releasePath = Paths.get("/etc/os-release", new String[0]);
            String release = Files.readString(releasePath, StandardCharsets.UTF_8);
            boolean isDebianBookworm = release.contains("VERSION_CODENAME=bookworm");
            Path modelPath = Paths.get("/sys/firmware/devicetree/base/model", new String[0]);
            String model = Files.readString(modelPath, StandardCharsets.UTF_8);
            boolean isRaspberryPi = model.startsWith("Raspberry Pi");
            return isDebianBookworm && isRaspberryPi;
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public Platform.OperatingSystem getOperatingSystem() {
        return this.operatingSystem;
    }

    @Override
    public Platform.Architecture getArchitecture() {
        return this.architecture;
    }

    @Override
    public boolean supportsUnixDomainSockets() {
        return this.supportsUnixDomainSockets;
    }

    @Override
    public boolean isRaspberryPi() {
        return this.isRaspberryPi;
    }
}

