/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.mods.dependency.refmap;

import net.fabricmc.loom.configuration.mods.dependency.refmap.MixinReferenceRemapper;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;

public class MixinRefmapInlinerClassVisitor
extends ClassVisitor {
    private final MixinReferenceRemapper remapper;
    private String className = null;

    public MixinRefmapInlinerClassVisitor(MixinReferenceRemapper remapper, ClassVisitor classVisitor) {
        super(589824, classVisitor);
        this.remapper = remapper;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.className = name;
        super.visit(version, access, name, signature, superName, interfaces);
    }

    public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
        AnnotationVisitor annotationVisitor = super.visitAnnotation(descriptor, visible);
        return new RefmapInlinerAnnotationVisitor(annotationVisitor);
    }

    public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
        MethodVisitor methodVisitor = super.visitMethod(access, name, descriptor, signature, exceptions);
        return new RefmapInlinerMethodVisitor(methodVisitor);
    }

    private class RefmapInlinerAnnotationVisitor
    extends AnnotationVisitor {
        private RefmapInlinerAnnotationVisitor(AnnotationVisitor annotationVisitor) {
            super(MixinRefmapInlinerClassVisitor.this.api, annotationVisitor);
        }

        public void visit(String name, Object value) {
            if (value instanceof String) {
                String strValue = (String)value;
                value = MixinRefmapInlinerClassVisitor.this.remapper.remapReference(MixinRefmapInlinerClassVisitor.this.className, strValue);
            }
            super.visit(name, value);
        }

        public AnnotationVisitor visitArray(String name) {
            AnnotationVisitor annotationVisitor = super.visitArray(name);
            return new RefmapInlinerAnnotationVisitor(annotationVisitor);
        }

        public AnnotationVisitor visitAnnotation(String name, String descriptor) {
            AnnotationVisitor annotationVisitor = super.visitAnnotation(name, descriptor);
            return new RefmapInlinerAnnotationVisitor(annotationVisitor);
        }
    }

    private class RefmapInlinerMethodVisitor
    extends MethodVisitor {
        private RefmapInlinerMethodVisitor(MethodVisitor methodVisitor) {
            super(MixinRefmapInlinerClassVisitor.this.api, methodVisitor);
        }

        public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
            AnnotationVisitor annotationVisitor = super.visitAnnotation(descriptor, visible);
            return new RefmapInlinerAnnotationVisitor(annotationVisitor);
        }
    }
}

