/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.task;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.gradle.api.GradleException;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.SourceTask;
import org.gradle.api.tasks.TaskAction;
import org.gradle.workers.WorkAction;
import org.gradle.workers.WorkParameters;
import org.gradle.workers.WorkQueue;
import org.gradle.workers.WorkerExecutor;
import org.jetbrains.annotations.VisibleForTesting;
import org.jspecify.annotations.Nullable;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ValidateMixinNameTask
extends SourceTask {
    @Input
    abstract Property<Boolean> getSoftFailures();

    @Inject
    protected abstract WorkerExecutor getWorkerExecutor();

    @Inject
    public ValidateMixinNameTask() {
        this.setGroup("verification");
        this.getProject().getTasks().getByName("check").dependsOn(new Object[]{this});
        this.getSoftFailures().convention((Object)false);
    }

    @TaskAction
    public void run() {
        WorkQueue workQueue = this.getWorkerExecutor().noIsolation();
        workQueue.submit(ValidateMixinAction.class, params -> {
            params.getInputClasses().from(new Object[]{this.getSource().matching(pattern -> pattern.include(new String[]{"**/*.class"}))});
            params.getSoftFailures().set(this.getSoftFailures());
        });
    }

    private static String toSimpleName(String internalName) {
        return internalName.substring(internalName.lastIndexOf("/") + 1);
    }

    private static @Nullable Mixin getMixin(File file) {
        Mixin mixin;
        FileInputStream is = new FileInputStream(file);
        try {
            mixin = ValidateMixinNameTask.getMixin(is);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)is).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new UncheckedIOException("Failed to read input file: " + String.valueOf(file), e);
            }
        }
        ((InputStream)is).close();
        return mixin;
    }

    @VisibleForTesting
    public static @Nullable Mixin getMixin(InputStream is) throws IOException {
        ClassReader reader = new ClassReader(is);
        MixinTargetClassVisitor classVisitor = new MixinTargetClassVisitor();
        reader.accept((ClassVisitor)classVisitor, 1);
        if (classVisitor.mixinTarget != null && classVisitor.targets == 1) {
            return new Mixin(classVisitor.className, classVisitor.mixinTarget, classVisitor.accessor);
        }
        return null;
    }

    public static abstract class ValidateMixinAction
    implements WorkAction<ValidateMixinsParams> {
        public static final Logger LOGGER = LoggerFactory.getLogger(ValidateMixinAction.class);

        public void execute() {
            Set files = ((ValidateMixinsParams)this.getParameters()).getInputClasses().getAsFileTree().getFiles();
            LinkedList<String> errors = new LinkedList<String>();
            for (File file : files) {
                Mixin mixin = ValidateMixinNameTask.getMixin(file);
                if (mixin == null) continue;
                String mixinClassName = ValidateMixinNameTask.toSimpleName(mixin.className);
                String expectedMixinClassName = mixin.expectedClassName();
                if (expectedMixinClassName.startsWith("class_") || expectedMixinClassName.equals(mixinClassName)) continue;
                errors.add("%s -> %s".formatted(mixin.className, expectedMixinClassName));
            }
            if (errors.isEmpty()) {
                return;
            }
            String message = "Mixin name validation failed: " + errors.stream().collect(Collectors.joining(System.lineSeparator()));
            if (((Boolean)((ValidateMixinsParams)this.getParameters()).getSoftFailures().get()).booleanValue()) {
                LOGGER.warn(message);
                return;
            }
            throw new GradleException("Mixin name validation failed: " + errors.stream().collect(Collectors.joining(System.lineSeparator())));
        }
    }

    @VisibleForTesting
    public record Mixin(String className, Type target, boolean accessor) {
        public String expectedClassName() {
            return ValidateMixinNameTask.toSimpleName(this.target.getInternalName()).replace("$", "") + (this.accessor ? "Accessor" : "Mixin");
        }
    }

    private static class MixinTargetClassVisitor
    extends ClassVisitor {
        Type mixinTarget;
        String className;
        boolean accessor;
        int targets = 0;
        boolean isInterface;

        protected MixinTargetClassVisitor() {
            super(589824);
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.className = name;
            this.isInterface = (access & 0x200) != 0;
            super.visit(version, access, name, signature, superName, interfaces);
        }

        public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
            AnnotationVisitor av = super.visitAnnotation(descriptor, visible);
            if ("Lorg/spongepowered/asm/mixin/Mixin;".equals(descriptor)) {
                av = new MixinAnnotationVisitor(av);
            }
            return av;
        }

        public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
            MethodVisitor mv = super.visitMethod(access, name, descriptor, signature, exceptions);
            if (this.mixinTarget != null) {
                mv = new MixinMethodVisitor(mv);
            }
            return mv;
        }

        private class MixinAnnotationVisitor
        extends AnnotationVisitor {
            MixinAnnotationVisitor(AnnotationVisitor annotationVisitor) {
                super(589824, annotationVisitor);
            }

            public AnnotationVisitor visitArray(String name) {
                AnnotationVisitor av = super.visitArray(name);
                if ("value".equals(name)) {
                    return new AnnotationVisitor(589824, av){

                        public void visit(String name, Object value) {
                            MixinTargetClassVisitor.this.mixinTarget = Objects.requireNonNull((Type)value);
                            ++MixinTargetClassVisitor.this.targets;
                            super.visit(name, value);
                        }
                    };
                }
                return av;
            }
        }

        private class MixinMethodVisitor
        extends MethodVisitor {
            protected MixinMethodVisitor(MethodVisitor methodVisitor) {
                super(589824, methodVisitor);
            }

            public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
                if ("Lorg/spongepowered/asm/mixin/gen/Accessor;".equals(descriptor)) {
                    MixinTargetClassVisitor.this.accessor = true;
                } else if ("Lorg/spongepowered/asm/mixin/gen/Invoker;".equals(descriptor)) {
                    MixinTargetClassVisitor.this.accessor = true;
                }
                return super.visitAnnotation(descriptor, visible);
            }
        }
    }

    public static interface ValidateMixinsParams
    extends WorkParameters {
        public ConfigurableFileCollection getInputClasses();

        public Property<Boolean> getSoftFailures();
    }
}

