/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.util.fmj.gen;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;

public final class GeneratorUtils {
    private GeneratorUtils() {
    }

    public static void add(JsonObject json, String key, Property<String> property) {
        GeneratorUtils.add(json, key, property, JsonPrimitive::new);
    }

    public static void addRequired(JsonObject json, String key, Property<String> property) {
        GeneratorUtils.addRequired(json, key, property, JsonPrimitive::new);
    }

    public static void addStringOrArray(JsonObject json, String key, ListProperty<String> property) {
        if (((List)property.get()).isEmpty()) {
            return;
        }
        GeneratorUtils.add(json, key, property, GeneratorUtils::stringOrArray);
    }

    public static <V> void addSingleOrArray(JsonObject json, String key, ListProperty<V> property, Function<V, JsonElement> converter) {
        if (((List)property.get()).isEmpty()) {
            return;
        }
        GeneratorUtils.add(json, key, property, (List<V> entries) -> GeneratorUtils.singleOrArray(entries, converter));
    }

    public static <V> void addArray(JsonObject json, String key, ListProperty<V> property, Function<V, JsonElement> converter) {
        if (((List)property.get()).isEmpty()) {
            return;
        }
        GeneratorUtils.add(json, key, property, (List<V> entries) -> GeneratorUtils.array(entries, converter));
    }

    public static <V, P extends Property<V>> void add(JsonObject json, String key, P property, Function<V, JsonElement> converter) {
        if (!property.isPresent()) {
            return;
        }
        json.add(key, converter.apply(property.get()));
    }

    public static <V, P extends Property<V>> void addRequired(JsonObject json, String key, P property, Function<V, JsonElement> converter) {
        property.get();
        GeneratorUtils.add(json, key, property, converter);
    }

    public static <V> void add(JsonObject json, String key, ListProperty<V> property, Function<List<V>, JsonElement> converter) {
        if (((List)property.get()).isEmpty()) {
            return;
        }
        json.add(key, converter.apply((List)property.get()));
    }

    public static <K, V> void add(JsonObject json, String key, MapProperty<K, V> property, Function<Map<K, V>, JsonElement> converter) {
        if (((Map)property.get()).isEmpty()) {
            return;
        }
        json.add(key, converter.apply((Map)property.get()));
    }

    public static void add(JsonObject json, String key, MapProperty<String, String> property) {
        if (((Map)property.get()).isEmpty()) {
            return;
        }
        GeneratorUtils.add(json, key, property, GeneratorUtils::map);
    }

    public static JsonElement stringOrArray(List<String> strings) {
        return GeneratorUtils.singleOrArray(strings, JsonPrimitive::new);
    }

    public static <V> JsonElement singleOrArray(List<V> entries, Function<V, JsonElement> converter) {
        if (entries.size() == 1) {
            return converter.apply(entries.getFirst());
        }
        return GeneratorUtils.array(entries, converter);
    }

    public static <V> JsonElement array(List<V> entries, Function<V, JsonElement> converter) {
        JsonArray array = new JsonArray();
        for (V entry : entries) {
            array.add(converter.apply(entry));
        }
        return array;
    }

    public static JsonObject map(Map<String, String> map) {
        JsonObject obj = new JsonObject();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            obj.addProperty(entry.getKey(), entry.getValue());
        }
        return obj;
    }
}

