/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.providers.mappings.tiny;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import net.fabricmc.loom.api.mappings.layered.MappingsNamespace;
import net.fabricmc.loom.configuration.providers.mappings.IntermediateMappingsService;
import net.fabricmc.loom.configuration.providers.mappings.tiny.UnobfuscatedMappingNsCompleter;
import net.fabricmc.loom.configuration.providers.minecraft.MinecraftProvider;
import net.fabricmc.mappingio.MappingVisitor;
import net.fabricmc.mappingio.adapter.MappingSourceNsSwitch;
import net.fabricmc.mappingio.format.tiny.Tiny2FileReader;
import net.fabricmc.mappingio.format.tiny.Tiny2FileWriter;
import net.fabricmc.mappingio.tree.MemoryMappingTree;
import org.jetbrains.annotations.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MappingsMerger {
    private static final Logger LOGGER = LoggerFactory.getLogger(MappingsMerger.class);

    public static void mergeAndSaveMappings(Path from, Path out, MinecraftProvider minecraftProvider, IntermediateMappingsService intermediateMappingsService) throws IOException {
        long start = System.currentTimeMillis();
        LOGGER.info(":merging mappings");
        if (minecraftProvider.isLegacySplitOfficialNamespaceVersion()) {
            MappingsMerger.legacyMergedMergeAndSaveMappings(from, out, intermediateMappingsService);
        } else {
            MappingsMerger.mergeAndSaveMappings(from, out, intermediateMappingsService);
        }
        LOGGER.info(":merged mappings in {}ms", (Object)(System.currentTimeMillis() - start));
    }

    @VisibleForTesting
    public static void mergeAndSaveMappings(Path from, Path out, IntermediateMappingsService intermediateMappingsService) throws IOException {
        MemoryMappingTree intermediaryTree = new MemoryMappingTree();
        intermediateMappingsService.getMemoryMappingTree().accept((MappingVisitor)new MappingSourceNsSwitch((MappingVisitor)intermediaryTree, MappingsNamespace.INTERMEDIARY.toString()));
        try (BufferedReader reader = Files.newBufferedReader(from, StandardCharsets.UTF_8);){
            Tiny2FileReader.read((Reader)reader, (MappingVisitor)intermediaryTree);
        }
        MemoryMappingTree officialTree = new MemoryMappingTree();
        UnobfuscatedMappingNsCompleter nsCompleter = new UnobfuscatedMappingNsCompleter((MappingVisitor)officialTree, MappingsNamespace.NAMED.toString(), Map.of(MappingsNamespace.OFFICIAL.toString(), MappingsNamespace.INTERMEDIARY.toString()));
        MappingSourceNsSwitch nsSwitch = new MappingSourceNsSwitch((MappingVisitor)nsCompleter, MappingsNamespace.OFFICIAL.toString());
        intermediaryTree.accept((MappingVisitor)nsSwitch);
        MappingsMerger.inheritMappedNamesOfEnclosingClasses(officialTree);
        try (Tiny2FileWriter writer = new Tiny2FileWriter((Writer)Files.newBufferedWriter(out, StandardCharsets.UTF_8, new OpenOption[0]), false);){
            officialTree.accept((MappingVisitor)writer);
        }
    }

    @VisibleForTesting
    public static void legacyMergedMergeAndSaveMappings(Path from, Path out, IntermediateMappingsService intermediateMappingsService) throws IOException {
        MemoryMappingTree intermediaryTree = new MemoryMappingTree();
        intermediateMappingsService.getMemoryMappingTree().accept((MappingVisitor)intermediaryTree);
        try (BufferedReader reader = Files.newBufferedReader(from, StandardCharsets.UTF_8);){
            Tiny2FileReader.read((Reader)reader, (MappingVisitor)intermediaryTree);
        }
        MemoryMappingTree officialTree = new MemoryMappingTree();
        UnobfuscatedMappingNsCompleter nsCompleter = new UnobfuscatedMappingNsCompleter((MappingVisitor)officialTree, MappingsNamespace.NAMED.toString(), Map.of(MappingsNamespace.CLIENT_OFFICIAL.toString(), MappingsNamespace.INTERMEDIARY.toString(), MappingsNamespace.SERVER_OFFICIAL.toString(), MappingsNamespace.INTERMEDIARY.toString()));
        intermediaryTree.accept((MappingVisitor)nsCompleter);
        try (Tiny2FileWriter writer = new Tiny2FileWriter((Writer)Files.newBufferedWriter(out, StandardCharsets.UTF_8, new OpenOption[0]), false);){
            officialTree.accept((MappingVisitor)writer);
        }
    }

    private static void inheritMappedNamesOfEnclosingClasses(MemoryMappingTree tree) {
        assert (tree.getNamespaceId("intermediary") > -1);
        tree.setIndexByDstNames(true);
        tree.propagateOuterClassNames("intermediary", List.of("named"), false);
    }
}

