/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.accesswidener;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.inject.Inject;
import net.fabricmc.classtweaker.api.ClassTweaker;
import net.fabricmc.classtweaker.api.visitor.ClassTweakerVisitor;
import net.fabricmc.loom.api.mappings.layered.MappingsNamespace;
import net.fabricmc.loom.api.processor.MinecraftJarProcessor;
import net.fabricmc.loom.api.processor.ProcessorContext;
import net.fabricmc.loom.api.processor.SpecContext;
import net.fabricmc.loom.configuration.accesswidener.AccessWidenerEntry;
import net.fabricmc.loom.configuration.accesswidener.AccessWidenerTransformer;
import net.fabricmc.loom.configuration.accesswidener.LocalAccessWidenerEntry;
import net.fabricmc.loom.configuration.accesswidener.ModAccessWidenerEntry;
import net.fabricmc.loom.configuration.accesswidener.TransitiveAccessWidenerMappingsProcessor;
import net.fabricmc.loom.util.LazyCloseable;
import net.fabricmc.loom.util.fmj.FabricModJson;
import net.fabricmc.loom.util.fmj.ModEnvironment;
import net.fabricmc.tinyremapper.TinyRemapper;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.jspecify.annotations.Nullable;

public class AccessWidenerJarProcessor
implements MinecraftJarProcessor<Spec> {
    private final String name;
    private final boolean includeTransitive;
    private final RegularFileProperty localAccessWidenerProperty;

    @Inject
    public AccessWidenerJarProcessor(String name, boolean includeTransitive, RegularFileProperty localAccessWidenerProperty) {
        this.name = name;
        this.includeTransitive = includeTransitive;
        this.localAccessWidenerProperty = localAccessWidenerProperty;
    }

    @Override
    public @Nullable Spec buildSpec(SpecContext context) {
        ArrayList<Record> accessWideners = new ArrayList<Record>();
        if (this.localAccessWidenerProperty.isPresent()) {
            Path path = ((RegularFile)this.localAccessWidenerProperty.get()).getAsFile().toPath();
            if (Files.notExists(path, new LinkOption[0])) {
                throw new UncheckedIOException(new FileNotFoundException("Could not find access widener file at {%s}".formatted(path)));
            }
            accessWideners.add(LocalAccessWidenerEntry.create(path));
        }
        if (this.includeTransitive) {
            for (FabricModJson fabricModJson : context.modDependencies()) {
                accessWideners.addAll(ModAccessWidenerEntry.readAll(fabricModJson, true));
            }
        }
        if (accessWideners.isEmpty()) {
            return null;
        }
        return new Spec(accessWideners.stream().sorted(Comparator.comparing(AccessWidenerEntry::getSortKey)).toList());
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void processJar(Path jar, Spec spec, ProcessorContext context) throws IOException {
        ClassTweaker classTweaker = this.getClassTweaker(spec, context);
        AccessWidenerTransformer transformer = new AccessWidenerTransformer(classTweaker);
        transformer.apply(jar);
    }

    private ClassTweaker getClassTweaker(Spec spec, ProcessorContext context) throws IOException {
        List<AccessWidenerEntry> accessWideners = spec.accessWidenersForContext(context);
        ClassTweaker classTweaker = ClassTweaker.newInstance();
        if (context.disableObfuscation()) {
            for (AccessWidenerEntry widener : accessWideners) {
                widener.readOfficial((ClassTweakerVisitor)classTweaker);
            }
            return classTweaker;
        }
        try (LazyCloseable<TinyRemapper> remapper = context.createRemapper(MappingsNamespace.INTERMEDIARY, MappingsNamespace.NAMED);){
            for (AccessWidenerEntry widener : accessWideners) {
                widener.read((ClassTweakerVisitor)classTweaker, remapper);
            }
        }
        return classTweaker;
    }

    @Override
    public @Nullable MinecraftJarProcessor.MappingsProcessor<Spec> processMappings() {
        return TransitiveAccessWidenerMappingsProcessor.INSTANCE;
    }

    public record Spec(List<AccessWidenerEntry> accessWideners) implements MinecraftJarProcessor.Spec
    {
        List<AccessWidenerEntry> accessWidenersForContext(ProcessorContext context) {
            return this.accessWideners.stream().filter(entry -> Spec.isSupported(entry.environment(), context)).toList();
        }

        private static boolean isSupported(ModEnvironment modEnvironment, ProcessorContext context) {
            if (context.isMerged()) {
                return true;
            }
            if (context.includesClient() && modEnvironment.isClient()) {
                return true;
            }
            if (context.includesServer() && modEnvironment.isServer()) {
                return true;
            }
            return modEnvironment == ModEnvironment.UNIVERSAL;
        }
    }
}

