/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HexFormat;
import java.util.List;
import org.gradle.api.Project;
import org.gradle.api.file.FileCollection;

public final class Checksum {
    private final DataConsumer consumer;

    public static Checksum of(byte[] data) {
        return new Checksum(digest -> digest.write(data));
    }

    public static Checksum of(String str) {
        return new Checksum(digest -> digest.write(str));
    }

    public static Checksum of(File file) {
        return Checksum.of(file.toPath());
    }

    public static Checksum of(Path file) {
        return new Checksum(digest -> {
            try (InputStream is = Files.newInputStream(file, new OpenOption[0]);){
                is.transferTo(digest);
            }
        });
    }

    public static Checksum of(Project project) {
        return Checksum.of(project.getProjectDir().getAbsolutePath() + ":" + project.getPath());
    }

    public static Checksum of(FileCollection files) {
        return new Checksum(os -> {
            for (File file : files) {
                InputStream is = Files.newInputStream(file.toPath(), new OpenOption[0]);
                try {
                    is.transferTo(os);
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
        });
    }

    public static Checksum of(List<Checksum> others) {
        return new Checksum(os -> {
            for (Checksum other : others) {
                other.consumer.accept(os);
            }
        });
    }

    private Checksum(DataConsumer consumer) {
        this.consumer = consumer;
    }

    public Result sha1() {
        return this.computeResult("SHA-1");
    }

    public Result sha256() {
        return this.computeResult("SHA-256");
    }

    public Result md5() {
        return this.computeResult("MD5");
    }

    private Result computeResult(String algorithm) {
        MessageDigest digest;
        try {
            digest = MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        try (MessageDigestOutputStream os = new MessageDigestOutputStream(digest);){
            this.consumer.accept(os);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to compute checksum", e);
        }
        return new Result(digest.digest());
    }

    @FunctionalInterface
    private static interface DataConsumer {
        public void accept(MessageDigestOutputStream var1) throws IOException;
    }

    public record Result(byte[] digest) {
        public String hex() {
            return HexFormat.of().formatHex(this.digest());
        }

        public String hex(int length) {
            return this.hex().substring(0, length);
        }

        public boolean matchesStr(String other) {
            return this.hex().equalsIgnoreCase(other);
        }
    }

    private static class MessageDigestOutputStream
    extends OutputStream {
        private final MessageDigest digest;

        private MessageDigestOutputStream(MessageDigest digest) {
            this.digest = digest;
        }

        @Override
        public void write(int b) {
            this.digest.update((byte)b);
        }

        @Override
        public void write(byte[] b, int off, int len) {
            this.digest.update(b, off, len);
        }

        public void write(String string) throws IOException {
            this.write(string.getBytes(StandardCharsets.UTF_8));
        }
    }
}

