/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.providers.minecraft.library;

import org.jspecify.annotations.Nullable;

public record Library(String group, String name, String version, @Nullable String classifier, Target target) {
    public static Library fromMaven(String name, Target target) {
        String[] split = name.split(":");
        assert (split.length == 3 || split.length == 4);
        return new Library(split[0], split[1], split[2], split.length == 4 ? split[3] : null, target);
    }

    public boolean is(String str) {
        if (str.contains(":")) {
            String[] split = str.split(":");
            assert (split.length == 2);
            return this.group.equals(split[0]) && this.name.equals(split[1]);
        }
        return this.group.equals(str);
    }

    public String mavenNotation() {
        if (this.classifier != null) {
            return "%s:%s:%s:%s".formatted(this.group, this.name, this.version, this.classifier);
        }
        return "%s:%s:%s".formatted(this.group, this.name, this.version);
    }

    public Library withVersion(String version) {
        return new Library(this.group, this.name, version, this.classifier, this.target);
    }

    public Library withClassifier(@Nullable String classifier) {
        return new Library(this.group, this.name, this.version, classifier, this.target);
    }

    public Library withTarget(Target target) {
        return new Library(this.group, this.name, this.version, this.classifier, target);
    }

    public static enum Target {
        RUNTIME,
        COMPILE,
        NATIVES,
        LOCAL_MOD;

    }
}

