/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.task;

import com.google.gson.JsonObject;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import javax.inject.Inject;
import net.fabricmc.classtweaker.api.ClassTweakerReader;
import net.fabricmc.classtweaker.api.ClassTweakerWriter;
import net.fabricmc.classtweaker.api.visitor.ClassTweakerVisitor;
import net.fabricmc.classtweaker.visitors.ClassTweakerRemapperVisitor;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.build.nesting.JarNester;
import net.fabricmc.loom.build.nesting.NestableJarGenerationTask;
import net.fabricmc.loom.configuration.accesswidener.AccessWidenerFile;
import net.fabricmc.loom.configuration.mods.ArtifactMetadata;
import net.fabricmc.loom.task.AbstractRemapJarTask;
import net.fabricmc.loom.task.service.ClientEntriesService;
import net.fabricmc.loom.task.service.MixinRefmapService;
import net.fabricmc.loom.task.service.TinyRemapperService;
import net.fabricmc.loom.util.Pair;
import net.fabricmc.loom.util.SidedClassVisitor;
import net.fabricmc.loom.util.ZipUtils;
import net.fabricmc.loom.util.fmj.FabricModJsonUtils;
import net.fabricmc.loom.util.service.ScopedServiceFactory;
import net.fabricmc.loom.util.service.ServiceFactory;
import net.fabricmc.tinyremapper.InputTag;
import net.fabricmc.tinyremapper.OutputConsumerPath;
import net.fabricmc.tinyremapper.TinyRemapper;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.ApiStatus;
import org.jspecify.annotations.Nullable;
import org.objectweb.asm.commons.Remapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RemapJarTask
extends AbstractRemapJarTask {
    @InputFiles
    public abstract ConfigurableFileCollection getNestedJars();

    @Input
    public abstract Property<Boolean> getAddNestedDependencies();

    @Input
    public abstract Property<Boolean> getOptimizeFabricModJson();

    @Input
    @ApiStatus.Internal
    public abstract Property<Boolean> getUseMixinAP();

    @Nested
    public abstract Property<TinyRemapperService.Options> getTinyRemapperServiceOptions();

    @Nested
    public abstract ListProperty<MixinRefmapService.Options> getMixinRefmapServiceOptions();

    @Inject
    public RemapJarTask() {
        ConfigurationContainer configurations = this.getProject().getConfigurations();
        this.getClasspath().from(new Object[]{configurations.getByName("compileClasspath")});
        this.getAddNestedDependencies().convention((Object)true).finalizeValueOnRead();
        this.getOptimizeFabricModJson().convention((Object)false).finalizeValueOnRead();
        TaskProvider processIncludeJars = this.getProject().getTasks().named("processIncludeJars", NestableJarGenerationTask.class);
        this.getNestedJars().from(new Object[]{processIncludeJars.map(task -> this.getProject().fileTree((Object)task.getOutputDirectory()))});
        this.getNestedJars().builtBy(new Object[]{processIncludeJars});
        this.getUseMixinAP().set(LoomGradleExtension.get(this.getProject()).getMixin().getUseLegacyMixinAp());
        this.setReproducibleFileOrder(true);
        this.setPreserveFileTimestamps(false);
        this.getJarType().set((Object)"classes");
        this.getTinyRemapperServiceOptions().set(TinyRemapperService.createOptions(this));
        this.getMixinRefmapServiceOptions().set(MixinRefmapService.createOptions(this));
    }

    protected void copy() {
        super.copy();
        this.submitWork(RemapAction.class, params -> {
            if (((Boolean)this.getAddNestedDependencies().get()).booleanValue()) {
                params.getNestedJars().from(new Object[]{this.getNestedJars()});
            }
            if (!params.namespacesMatch()) {
                params.getTinyRemapperServiceOptions().set(this.getTinyRemapperServiceOptions());
                params.getMixinRefmapServiceOptions().set(this.getMixinRefmapServiceOptions());
                params.getRemapClasspath().from(new Object[]{this.getClasspath()});
                boolean mixinAp = (Boolean)this.getUseMixinAP().get();
                params.getUseMixinExtension().set((Object)(!mixinAp ? 1 : 0));
                ArtifactMetadata.MixinRemapType refmapRemapType = mixinAp ? ArtifactMetadata.MixinRemapType.MIXIN : ArtifactMetadata.MixinRemapType.STATIC;
                params.getManifestAttributes().put((Object)"Fabric-Loom-Mixin-Remap-Type", (Object)refmapRemapType.manifestValue());
            }
            params.getOptimizeFmj().set((Object)((Boolean)this.getOptimizeFabricModJson().get()));
        });
    }

    @Override
    protected Provider<? extends ClientEntriesService.Options> getClientOnlyEntriesOptionsProvider(SourceSet clientSourceSet) {
        return ClientEntriesService.Classes.createOptions(this.getProject(), clientSourceSet);
    }

    public static abstract class RemapAction
    extends AbstractRemapJarTask.AbstractRemapAction<RemapParams> {
        private static final Logger LOGGER = LoggerFactory.getLogger(RemapAction.class);
        private @Nullable TinyRemapperService tinyRemapperService;
        private @Nullable TinyRemapper tinyRemapper;
        private Path inputFile;

        @Override
        protected void execute(Path inputFile) throws IOException {
            try (ScopedServiceFactory serviceFactory = new ScopedServiceFactory();){
                LOGGER.info("Remapping {} to {}", (Object)inputFile, (Object)this.outputFile);
                this.inputFile = inputFile;
                this.tinyRemapperService = ((RemapParams)this.getParameters()).getTinyRemapperServiceOptions().isPresent() ? (TinyRemapperService)serviceFactory.get((TinyRemapperService.Options)((RemapParams)this.getParameters()).getTinyRemapperServiceOptions().get()) : null;
                this.prepare();
                if (this.tinyRemapperService != null) {
                    this.tinyRemapper = this.tinyRemapperService.getTinyRemapperForRemapping();
                    this.remap();
                } else {
                    Files.copy(inputFile, this.outputFile, StandardCopyOption.REPLACE_EXISTING);
                }
                if (((RemapParams)this.getParameters()).getClientOnlyEntries().isPresent()) {
                    this.markClientOnlyClasses();
                }
                this.remapAccessWidener();
                this.addRefmaps(serviceFactory);
                this.addNestedJars();
                this.modifyJarManifest();
                this.rewriteJar();
                if (((Boolean)((RemapParams)this.getParameters()).getOptimizeFmj().get()).booleanValue()) {
                    this.optimizeFMJ();
                }
                if (this.tinyRemapperService != null) {
                    this.tinyRemapperService.close();
                }
                LOGGER.debug("Finished remapping {}", (Object)inputFile);
            }
        }

        private void prepare() {
            if (this.tinyRemapperService != null) {
                this.tinyRemapperService.getTinyRemapperForInputs().readInputsAsync(this.tinyRemapperService.getOrCreateTag(this.inputFile), new Path[]{this.inputFile});
            }
        }

        private void remap() throws IOException {
            Objects.requireNonNull(this.tinyRemapperService, "tinyRemapperService");
            Objects.requireNonNull(this.tinyRemapper, "tinyRemapper");
            Files.deleteIfExists(this.outputFile);
            try (OutputConsumerPath outputConsumer = new OutputConsumerPath.Builder(this.outputFile).build();){
                outputConsumer.addNonClassFiles(this.inputFile);
                this.tinyRemapper.apply((BiConsumer)outputConsumer, new InputTag[]{this.tinyRemapperService.getOrCreateTag(this.inputFile)});
            }
        }

        private void markClientOnlyClasses() throws IOException {
            Stream<Pair<String, ZipUtils.UnsafeUnaryOperator<byte[]>>> tranformers = ((List)((RemapParams)this.getParameters()).getClientOnlyEntries().get()).stream().map(s -> new Pair<String, ZipUtils.AsmClassOperator>((String)s, classVisitor -> SidedClassVisitor.CLIENT.insertApplyVisitor(null, classVisitor)));
            ZipUtils.transform(this.outputFile, tranformers);
        }

        private void remapAccessWidener() throws IOException {
            if (((RemapParams)this.getParameters()).namespacesMatch()) {
                return;
            }
            AccessWidenerFile accessWidenerFile = AccessWidenerFile.fromModJar(this.inputFile);
            if (accessWidenerFile == null) {
                return;
            }
            byte[] remapped = this.remapAccessWidener(accessWidenerFile.content());
            ZipUtils.replace(this.outputFile, accessWidenerFile.path(), remapped);
        }

        private byte[] remapAccessWidener(byte[] input) {
            Objects.requireNonNull(this.tinyRemapper, "tinyRemapper");
            int version = ClassTweakerReader.readVersion((byte[])input);
            ClassTweakerWriter writer = ClassTweakerWriter.create((int)version);
            ClassTweakerRemapperVisitor remapper = new ClassTweakerRemapperVisitor((ClassTweakerVisitor)writer, (Remapper)this.tinyRemapper.getEnvironment().getRemapper(), (String)((RemapParams)this.getParameters()).getSourceNamespace().get(), (String)((RemapParams)this.getParameters()).getTargetNamespace().get());
            ClassTweakerReader reader = ClassTweakerReader.create((ClassTweakerVisitor)remapper);
            reader.read(input, null);
            return writer.getOutput();
        }

        private void addNestedJars() {
            ConfigurableFileCollection nestedJars = ((RemapParams)this.getParameters()).getNestedJars();
            if (nestedJars.isEmpty()) {
                LOGGER.info("No jars to nest");
                return;
            }
            JarNester.nestJars(nestedJars.getFiles(), this.outputFile.toFile(), LOGGER);
        }

        private void addRefmaps(ServiceFactory serviceFactory) throws IOException {
            if (((Boolean)((RemapParams)this.getParameters()).getUseMixinExtension().getOrElse((Object)false)).booleanValue()) {
                return;
            }
            for (MixinRefmapService.Options options : (List)((RemapParams)this.getParameters()).getMixinRefmapServiceOptions().get()) {
                MixinRefmapService mixinRefmapService = (MixinRefmapService)serviceFactory.get(options);
                mixinRefmapService.applyToJar(this.outputFile);
            }
        }

        private void optimizeFMJ() throws IOException {
            if (!ZipUtils.contains(this.outputFile, "fabric.mod.json")) {
                return;
            }
            ZipUtils.transformJson(JsonObject.class, this.outputFile, "fabric.mod.json", FabricModJsonUtils::optimizeFmj);
        }
    }

    public static interface RemapParams
    extends AbstractRemapJarTask.AbstractRemapParams {
        public ConfigurableFileCollection getNestedJars();

        public ConfigurableFileCollection getRemapClasspath();

        public Property<Boolean> getUseMixinExtension();

        public Property<Boolean> getOptimizeFmj();

        public Property<TinyRemapperService.Options> getTinyRemapperServiceOptions();

        public ListProperty<MixinRefmapService.Options> getMixinRefmapServiceOptions();
    }
}

