/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration;

import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.api.RemapConfigurationSettings;
import net.fabricmc.loom.util.Strings;
import net.fabricmc.loom.util.gradle.SourceSetHelper;
import org.gradle.api.Action;
import org.gradle.api.NamedDomainObjectList;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.attributes.Usage;
import org.gradle.api.tasks.SourceSet;
import org.jetbrains.annotations.VisibleForTesting;

public final class RemapConfigurations {
    private static final List<ConfigurationOption> OPTIONS = List.of(new ConfigurationOption(RemapConfigurations.mainOnly(SourceSet::getApiConfigurationName), true, true, RemapConfigurationSettings.PublishingMode.COMPILE_AND_RUNTIME), new ConfigurationOption(SourceSet::getImplementationConfigurationName, true, true, RemapConfigurationSettings.PublishingMode.RUNTIME_ONLY), new ConfigurationOption(SourceSet::getCompileOnlyConfigurationName, true, false, RemapConfigurationSettings.PublishingMode.NONE), new ConfigurationOption(RemapConfigurations.mainOnly(SourceSet::getCompileOnlyApiConfigurationName), true, false, RemapConfigurationSettings.PublishingMode.COMPILE_ONLY), new ConfigurationOption(SourceSet::getRuntimeOnlyConfigurationName, false, true, RemapConfigurationSettings.PublishingMode.RUNTIME_ONLY), new ConfigurationOption(RemapConfigurations.mainOnly("localRuntime"), false, true, RemapConfigurationSettings.PublishingMode.NONE));

    private RemapConfigurations() {
    }

    public static void setupForSourceSet(Project project, SourceSet sourceSet) {
        LoomGradleExtension extension = LoomGradleExtension.get(project);
        for (ConfigurationOption option : RemapConfigurations.getValidOptions(sourceSet)) {
            extension.addRemapConfiguration(option.name(sourceSet), RemapConfigurations.configure(sourceSet, option.targetName(sourceSet), option.compileClasspath(), option.runtimeClasspath(), option.publishingMode()));
        }
    }

    public static void configureClientConfigurations(Project project, SourceSet clientSourceSet) {
        LoomGradleExtension extension = LoomGradleExtension.get(project);
        if (extension.disableObfuscation()) {
            return;
        }
        extension.createRemapConfigurations(clientSourceSet);
        NamedDomainObjectList<RemapConfigurationSettings> configurations = extension.getRemapConfigurations();
        SourceSet mainSourceSet = SourceSetHelper.getMainSourceSet(project);
        for (ConfigurationOption option : RemapConfigurations.getValidOptions(mainSourceSet)) {
            configurations.getByName(option.name(mainSourceSet), settings -> {
                String name = option.targetName(clientSourceSet);
                if (name == null) {
                    return;
                }
                settings.getClientSourceConfigurationName().set((Object)name);
            });
        }
    }

    public static Configuration getOrCreateCollectorConfiguration(Project project, RemapConfigurationSettings settings, boolean runtime) {
        return RemapConfigurations.getOrCreateCollectorConfiguration(project, (SourceSet)settings.getSourceSet().get(), runtime);
    }

    public static Configuration getOrCreateCollectorConfiguration(Project project, SourceSet sourceSet, boolean runtime) {
        String configurationName = "mod" + (runtime ? "Runtime" : "Compile") + "Classpath" + Strings.capitalize(sourceSet.getName()) + "Mapped";
        ConfigurationContainer configurations = project.getConfigurations();
        Configuration configuration = (Configuration)configurations.findByName(configurationName);
        if (configuration == null) {
            configuration = (Configuration)configurations.create(configurationName);
            configuration.setTransitive(false);
            Usage usage = (Usage)project.getObjects().named(Usage.class, runtime ? "java-runtime" : "java-api");
            configuration.attributes(attributes -> attributes.attribute(Usage.USAGE_ATTRIBUTE, (Object)usage));
            boolean isMainSourceSet = sourceSet.getName().equals("main");
            if (runtime) {
                RemapConfigurations.extendsFrom(sourceSet.getRuntimeClasspathConfigurationName(), configuration, project);
                if (isMainSourceSet) {
                    RemapConfigurations.extendsFrom("testRuntimeClasspath", configuration, project);
                }
            } else {
                RemapConfigurations.extendsFrom(sourceSet.getCompileClasspathConfigurationName(), configuration, project);
                RemapConfigurations.extendsFrom("modCompileClasspathMapped", configuration, project);
                if (isMainSourceSet) {
                    RemapConfigurations.extendsFrom("testCompileClasspath", configuration, project);
                }
            }
        }
        return configuration;
    }

    public static void applyToProject(Project project, RemapConfigurationSettings settings) {
        Configuration configuration = (Configuration)project.getConfigurations().create(settings.getName());
        configuration.setTransitive(true);
        if (((Boolean)settings.getOnCompileClasspath().get()).booleanValue()) {
            RemapConfigurations.extendsFrom("modCompileClasspath", configuration, project);
        }
        for (String outgoingConfigurationName : ((RemapConfigurationSettings.PublishingMode)((Object)settings.getPublishingMode().get())).outgoingConfigurations()) {
            RemapConfigurations.extendsFrom(outgoingConfigurationName, configuration, project);
        }
    }

    private static Action<RemapConfigurationSettings> configure(SourceSet sourceSet, String targetConfiguration, boolean compileClasspath, boolean runtimeClasspath, RemapConfigurationSettings.PublishingMode publishingMode) {
        return configuration -> {
            configuration.getSourceSet().convention((Object)sourceSet);
            configuration.getTargetConfigurationName().convention((Object)targetConfiguration);
            configuration.getOnCompileClasspath().convention((Object)compileClasspath);
            configuration.getOnRuntimeClasspath().convention((Object)runtimeClasspath);
            if ("main".equals(sourceSet.getName())) {
                configuration.getPublishingMode().convention((Object)publishingMode);
            }
        };
    }

    private static void extendsFrom(String name, Configuration configuration, Project project) {
        project.getConfigurations().named(name).configure(namedConfiguration -> namedConfiguration.extendsFrom(new Configuration[]{configuration}));
    }

    private static Function<SourceSet, String> mainOnly(Function<SourceSet, String> function) {
        return sourceSet -> sourceSet.getName().equals("main") ? (String)function.apply((SourceSet)sourceSet) : null;
    }

    private static Function<SourceSet, String> mainOnly(String name) {
        return RemapConfigurations.mainOnly((SourceSet sourceSet) -> name);
    }

    private static List<ConfigurationOption> getValidOptions(SourceSet sourceSet) {
        return OPTIONS.stream().filter(option -> option.validFor(sourceSet)).toList();
    }

    private static String capitalise(String str) {
        return str.substring(0, 1).toUpperCase(Locale.ROOT) + str.substring(1);
    }

    @VisibleForTesting
    public record ConfigurationOption(Function<SourceSet, String> targetNameFunc, boolean compileClasspath, boolean runtimeClasspath, RemapConfigurationSettings.PublishingMode publishingMode) {
        String targetName(SourceSet sourceSet) {
            return this.targetNameFunc.apply(sourceSet);
        }

        boolean validFor(SourceSet sourceSet) {
            return this.targetName(sourceSet) != null;
        }

        public String name(SourceSet sourceSet) {
            String targetName = this.targetName(sourceSet);
            if (targetName == null) {
                throw new UnsupportedOperationException("Configuration option is not available for sourceset (%s)".formatted(sourceSet.getName()));
            }
            if (targetName.startsWith(sourceSet.getName())) {
                targetName = targetName.substring(sourceSet.getName().length());
            }
            StringBuilder builder = new StringBuilder();
            builder.append("mod");
            if (!"main".equals(sourceSet.getName())) {
                builder.append(RemapConfigurations.capitalise(sourceSet.getName()));
            }
            builder.append(RemapConfigurations.capitalise(targetName));
            return builder.toString();
        }
    }
}

