/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.task;

import java.io.File;
import java.io.Serializable;
import java.util.Set;
import javax.inject.Inject;
import net.fabricmc.loom.build.nesting.JarNester;
import org.gradle.api.Action;
import org.gradle.api.Task;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.tasks.InputFiles;
import org.gradle.jvm.tasks.Jar;
import org.gradle.workers.WorkAction;
import org.gradle.workers.WorkParameters;
import org.gradle.workers.WorkQueue;
import org.gradle.workers.WorkerExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NestJarsAction
implements Action<Task>,
Serializable {
    @InputFiles
    public abstract ConfigurableFileCollection getJars();

    @Inject
    protected abstract WorkerExecutor getWorkerExecutor();

    public static void addToTask(Jar task, FileCollection jars) {
        NestJarsAction nestJarsAction = (NestJarsAction)task.getProject().getObjects().newInstance(NestJarsAction.class, new Object[0]);
        nestJarsAction.getJars().from(new Object[]{jars});
        task.getInputs().files(new Object[]{nestJarsAction.getJars()});
        task.doLast((Action)nestJarsAction);
    }

    public void execute(Task t) {
        Jar jarTask = (Jar)t;
        WorkQueue workQueue = this.getWorkerExecutor().noIsolation();
        workQueue.submit(NestAction.class, p -> {
            p.getArchiveFile().set(jarTask.getArchiveFile());
            p.getJars().setFrom((Iterable)this.getJars());
        });
    }

    public static abstract class NestAction
    implements WorkAction<NestJarsParameters> {
        private static final Logger LOGGER = LoggerFactory.getLogger(NestJarsAction.class);

        public void execute() {
            File jarFile = ((RegularFile)((NestJarsParameters)this.getParameters()).getArchiveFile().get()).getAsFile();
            Set jars = ((NestJarsParameters)this.getParameters()).getJars().getFiles();
            if (!jars.isEmpty()) {
                JarNester.nestJars(jars, jarFile, LOGGER);
                LOGGER.info("Nested {} jar(s) into {}", (Object)jars.size(), (Object)jarFile.getName());
            }
        }
    }

    public static interface NestJarsParameters
    extends WorkParameters {
        public RegularFileProperty getArchiveFile();

        public ConfigurableFileCollection getJars();
    }
}

