/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.task.service;

import daomephsta.unpick.api.ConstantUninliner;
import daomephsta.unpick.api.classresolvers.ClassResolvers;
import daomephsta.unpick.api.classresolvers.IClassResolver;
import daomephsta.unpick.api.constantgroupers.ConstantGroupers;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.api.mappings.layered.MappingsNamespace;
import net.fabricmc.loom.configuration.providers.mappings.MappingConfiguration;
import net.fabricmc.loom.configuration.providers.mappings.unpick.UnpickMetadata;
import net.fabricmc.loom.task.GenerateSourcesTask;
import net.fabricmc.loom.task.service.TinyRemapperService;
import net.fabricmc.loom.task.service.UnpickRemapperService;
import net.fabricmc.loom.util.AsyncZipProcessor;
import net.fabricmc.loom.util.Checksum;
import net.fabricmc.loom.util.FileSystemUtil;
import net.fabricmc.loom.util.SLF4JAdapterHandler;
import net.fabricmc.loom.util.service.Service;
import net.fabricmc.loom.util.service.ServiceFactory;
import net.fabricmc.loom.util.service.ServiceType;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.jspecify.annotations.Nullable;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnpickService
extends Service<Options> {
    private static final Logger LOGGER = LoggerFactory.getLogger(UnpickService.class);
    private static final java.util.logging.Logger JAVA_LOGGER = java.util.logging.Logger.getLogger("loom-unpick-service");
    public static final ServiceType<Options, UnpickService> TYPE;

    public static Provider<Options> createOptions(GenerateSourcesTask task) {
        Project project = task.getProject();
        return TYPE.maybeCreate(project, options -> {
            UnpickMetadata.V2 v2;
            LoomGradleExtension extension = LoomGradleExtension.get(project);
            MappingConfiguration mappingConfiguration = extension.getMappingConfiguration();
            if (!mappingConfiguration.hasUnpickDefinitions()) {
                return false;
            }
            UnpickMetadata unpickMetadata = mappingConfiguration.getUnpickMetadata();
            if (unpickMetadata instanceof UnpickMetadata.V2 && !Objects.equals((v2 = (UnpickMetadata.V2)unpickMetadata).namespace(), MappingsNamespace.NAMED.toString())) {
                options.getUnpickRemapperService().set(UnpickRemapperService.createOptions(project, v2));
            }
            ConfigurationContainer configurations = project.getConfigurations();
            File mappingsWorkingDir = mappingConfiguration.mappingsWorkingDir().toFile();
            options.getUnpickDefinitions().set(mappingConfiguration.getUnpickDefinitionsFile());
            options.getUnpickOutputJar().set(task.getInputJarName().map(s -> ((Directory)project.getLayout().dir(project.provider(() -> mappingsWorkingDir)).get()).file(s + "-unpicked.jar")));
            options.getUnpickConstantJar().setFrom((Iterable)configurations.getByName("mappingsConstants"));
            options.getUnpickClasspath().setFrom((Iterable)configurations.getByName("minecraftLibraries"));
            options.getUnpickClasspath().from(new Object[]{configurations.getByName("modCompileClasspathMapped")});
            options.getLenient().set((Object)(unpickMetadata instanceof UnpickMetadata.V1));
            extension.getMinecraftJars(MappingsNamespace.NAMED).forEach(arg_0 -> UnpickService.lambda$createOptions$2(options.getUnpickClasspath(), arg_0));
            return true;
        });
    }

    public UnpickService(Options options, ServiceFactory serviceFactory) {
        super(options, serviceFactory);
    }

    public Path unpickJar(Path inputJar, @Nullable Path existingClasses) throws IOException {
        List<Path> classpath = Stream.of(((Options)this.getOptions()).getUnpickClasspath().getFiles().stream().map(File::toPath), ((Options)this.getOptions()).getUnpickConstantJar().getFiles().stream().map(File::toPath), Stream.of(inputJar), Stream.ofNullable(existingClasses)).flatMap(Function.identity()).toList();
        Path outputJar = ((RegularFile)((Options)this.getOptions()).getUnpickOutputJar().get()).getAsFile().toPath();
        Files.deleteIfExists(outputJar);
        try (ZipFsClasspath zipFsClasspath = ZipFsClasspath.create(classpath);
             InputStream unpickDefinitions = this.getUnpickDefinitionsInputStream();){
            IClassResolver classResolver = zipFsClasspath.createClassResolver().chain(new IClassResolver[]{ClassResolvers.classpath()});
            ConstantUninliner uninliner = ConstantUninliner.builder().logger(JAVA_LOGGER).classResolver(classResolver).grouper(ConstantGroupers.dataDriven().logger(JAVA_LOGGER).lenient(((Boolean)((Options)this.getOptions()).getLenient().get()).booleanValue()).classResolver(classResolver).mappingSource(unpickDefinitions).build()).build();
            AsyncZipProcessor.processEntries(inputJar, outputJar, new UnpickZipProcessor(uninliner));
        }
        return outputJar;
    }

    private InputStream getUnpickDefinitionsInputStream() throws IOException {
        Path unpickDefinitionsPath = ((File)((Options)this.getOptions()).getUnpickDefinitions().getAsFile().get()).toPath();
        if (((Options)this.getOptions()).getUnpickRemapperService().isPresent()) {
            LOGGER.info("Remapping unpick definitions: {}", (Object)unpickDefinitionsPath);
            UnpickRemapperService unpickRemapperService = (UnpickRemapperService)this.getServiceFactory().get(((Options)this.getOptions()).getUnpickRemapperService());
            String remapped = unpickRemapperService.remap(unpickDefinitionsPath.toFile());
            return new ByteArrayInputStream(remapped.getBytes(StandardCharsets.UTF_8));
        }
        LOGGER.debug("Using unpick definitions: {}", (Object)unpickDefinitionsPath);
        return Files.newInputStream(unpickDefinitionsPath, new OpenOption[0]);
    }

    public String getUnpickCacheKey() {
        return Checksum.of(List.of(Checksum.of((File)((Options)this.getOptions()).getUnpickDefinitions().getAsFile().get()), Checksum.of((FileCollection)((Options)this.getOptions()).getUnpickConstantJar()), Checksum.of((String)((Options)this.getOptions()).getUnpickRemapperService().flatMap(options -> options.getTinyRemapper().flatMap(TinyRemapperService.Options::getFrom)).getOrElse((Object)"named")))).sha256().hex();
    }

    private static /* synthetic */ void lambda$createOptions$2(ConfigurableFileCollection rec$, Object xva$0) {
        rec$.from(new Object[]{xva$0});
    }

    static {
        JAVA_LOGGER.setUseParentHandlers(false);
        JAVA_LOGGER.addHandler(new SLF4JAdapterHandler(LOGGER, true));
        TYPE = new ServiceType<Options, UnpickService>(Options.class, UnpickService.class);
    }

    public static interface Options
    extends Service.Options {
        @InputFile
        public RegularFileProperty getUnpickDefinitions();

        @Optional
        @Nested
        public Property<UnpickRemapperService.Options> getUnpickRemapperService();

        @InputFiles
        public ConfigurableFileCollection getUnpickConstantJar();

        @InputFiles
        public ConfigurableFileCollection getUnpickClasspath();

        @OutputFile
        public RegularFileProperty getUnpickOutputJar();

        @Input
        public Property<Boolean> getLenient();
    }

    private record ZipFsClasspath(List<FileSystemUtil.Delegate> fileSystems) implements Closeable
    {
        private ZipFsClasspath {
            if (fileSystems.isEmpty()) {
                throw new IllegalArgumentException("No resolvers provided");
            }
        }

        public static ZipFsClasspath create(List<Path> classpath) throws IOException {
            ArrayList<FileSystemUtil.Delegate> fileSystems = new ArrayList<FileSystemUtil.Delegate>();
            for (Path path : classpath) {
                FileSystemUtil.Delegate fs = FileSystemUtil.getJarFileSystem(path, false);
                fileSystems.add(fs);
            }
            return new ZipFsClasspath(fileSystems);
        }

        public IClassResolver createClassResolver() {
            IClassResolver resolver = ClassResolvers.fromDirectory((Path)this.fileSystems.getFirst().getRoot());
            for (int i = 1; i < this.fileSystems.size(); ++i) {
                resolver = resolver.chain(new IClassResolver[]{ClassResolvers.fromDirectory((Path)this.fileSystems.get(i).getRoot())});
            }
            return resolver;
        }

        @Override
        public void close() throws IOException {
            for (FileSystemUtil.Delegate fileSystem : this.fileSystems) {
                fileSystem.close();
            }
        }
    }

    private record UnpickZipProcessor(ConstantUninliner uninliner) implements AsyncZipProcessor
    {
        @Override
        public void processEntryAsync(Path input, Path output) throws IOException {
            Files.createDirectories(output.getParent(), new FileAttribute[0]);
            String fileName = input.toAbsolutePath().toString();
            if (!fileName.endsWith(".class")) {
                Files.copy(input, output, new CopyOption[0]);
                return;
            }
            ClassNode classNode = new ClassNode();
            try (InputStream is = Files.newInputStream(input, new OpenOption[0]);){
                ClassReader reader = new ClassReader(is);
                reader.accept((ClassVisitor)classNode, 0);
            }
            LOGGER.debug("Unpick class: {}", (Object)classNode.name);
            this.uninliner.transform(classNode);
            ClassWriter writer = new ClassWriter(1);
            classNode.accept((ClassVisitor)writer);
            Files.write(output, writer.toByteArray(), new OpenOption[0]);
        }
    }
}

