/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.util.fmj;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.fabricmc.loom.util.fmj.FabricModJson;
import net.fabricmc.loom.util.fmj.FabricModJsonSource;
import net.fabricmc.loom.util.fmj.FabricModJsonUtils;
import net.fabricmc.loom.util.fmj.ModEnvironment;
import org.jspecify.annotations.Nullable;

public final class FabricModJsonV1
extends FabricModJson {
    FabricModJsonV1(JsonObject jsonObject, FabricModJsonSource source) {
        super(jsonObject, source);
    }

    @Override
    public int getVersion() {
        return 1;
    }

    @Override
    public @Nullable JsonElement getCustom(String key) {
        return FabricModJsonV1.getCustom(this.jsonObject, key);
    }

    static JsonElement getCustom(JsonObject jsonObject, String key) {
        if (!jsonObject.has("custom")) {
            return null;
        }
        JsonObject custom = jsonObject.getAsJsonObject("custom");
        if (!custom.has(key)) {
            return null;
        }
        return custom.get(key);
    }

    @Override
    public List<String> getMixinConfigurations() {
        JsonArray mixinArray = this.jsonObject.getAsJsonArray("mixins");
        if (mixinArray == null) {
            return Collections.emptyList();
        }
        return StreamSupport.stream(mixinArray.spliterator(), false).map(FabricModJsonV1::readMixinElement).collect(Collectors.toList());
    }

    private static String readMixinElement(JsonElement jsonElement) {
        if (jsonElement instanceof JsonPrimitive) {
            JsonPrimitive str = (JsonPrimitive)jsonElement;
            return str.getAsString();
        }
        if (jsonElement instanceof JsonObject) {
            JsonObject obj = (JsonObject)jsonElement;
            return obj.get("config").getAsString();
        }
        throw new FabricModJsonUtils.ParseException("Expected mixin element to be an object or string", new Object[0]);
    }

    @Override
    public Map<String, ModEnvironment> getClassTweakers() {
        if (!this.jsonObject.has("accessWidener")) {
            return Collections.emptyMap();
        }
        return Map.of(FabricModJsonUtils.readString(this.jsonObject, "accessWidener"), ModEnvironment.UNIVERSAL);
    }
}

