/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.providers.mappings.utils;

import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.Locale;
import java.util.Objects;
import net.fabricmc.loom.api.mappings.layered.MappingContext;
import net.fabricmc.loom.api.mappings.layered.spec.FileSpec;
import net.fabricmc.loom.util.download.DownloadException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public record URLFileSpec(String url) implements FileSpec
{
    private static final Logger LOGGER = LoggerFactory.getLogger(URLFileSpec.class);

    @Override
    public Path get(MappingContext context) {
        try {
            Path output = context.workingDirectory(String.format(Locale.ENGLISH, "%d.URLFileSpec", Objects.hash(this.url)));
            LOGGER.info("Downloading {} to {}", (Object)this.url, (Object)output);
            context.download(this.url).defaultCache().downloadPath(output);
            return output;
        }
        catch (DownloadException e) {
            throw new UncheckedIOException("Failed to download: " + this.url, e);
        }
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.url.toString());
    }
}

