/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.api.processor;

import java.util.Comparator;
import java.util.List;
import java.util.stream.Stream;
import net.fabricmc.loom.api.mappings.layered.MappingsNamespace;
import net.fabricmc.loom.configuration.processors.speccontext.ProjectView;
import net.fabricmc.loom.util.fmj.FabricModJson;
import org.gradle.api.Project;

public interface SpecContext {
    public List<FabricModJson> modDependencies();

    public List<FabricModJson> localMods();

    public List<FabricModJson> modDependenciesCompileRuntime();

    public List<FabricModJson> modDependenciesCompileRuntimeClient();

    public MappingsNamespace productionNamespace();

    default public List<FabricModJson> allMods() {
        return Stream.concat(this.modDependencies().stream(), this.localMods().stream()).toList();
    }

    public static Stream<Project> getDependentProjects(ProjectView projectView) {
        Stream<Project> runtimeProjects = projectView.getLoomProjectDependencies("runtimeClasspath");
        Stream<Project> compileProjects = projectView.getLoomProjectDependencies("compileClasspath");
        return Stream.concat(runtimeProjects, compileProjects).distinct();
    }

    public static List<FabricModJson> distinctSorted(List<FabricModJson> mods) {
        return mods.stream().distinct().sorted(Comparator.comparing(FabricModJson::getId)).toList();
    }
}

