/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.providers.mappings.extras.annotations;

import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.fabricmc.loom.configuration.providers.mappings.extras.annotations.AnnotationsData;
import net.fabricmc.loom.configuration.providers.mappings.extras.annotations.BaseAnnotationData;
import net.fabricmc.loom.configuration.providers.mappings.extras.annotations.GenericAnnotationData;
import net.fabricmc.loom.configuration.providers.mappings.extras.annotations.MethodAnnotationData;
import net.fabricmc.loom.configuration.providers.mappings.extras.annotations.TypeAnnotationKey;
import net.fabricmc.tinyremapper.TinyRemapper;
import net.fabricmc.tinyremapper.api.TrRemapper;
import org.jspecify.annotations.Nullable;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.TypeAnnotationNode;

public record ClassAnnotationData(@SerializedName(value="remove") Set<String> annotationsToRemove, @SerializedName(value="add") List<AnnotationNode> annotationsToAdd, @SerializedName(value="type_remove") Set<TypeAnnotationKey> typeAnnotationsToRemove, @SerializedName(value="type_add") List<TypeAnnotationNode> typeAnnotationsToAdd, Map<String, GenericAnnotationData> fields, Map<String, MethodAnnotationData> methods) implements BaseAnnotationData
{
    public ClassAnnotationData {
        if (annotationsToRemove == null) {
            annotationsToRemove = new LinkedHashSet<String>();
        }
        if (annotationsToAdd == null) {
            annotationsToAdd = new ArrayList<AnnotationNode>();
        }
        if (typeAnnotationsToRemove == null) {
            typeAnnotationsToRemove = new LinkedHashSet<TypeAnnotationKey>();
        }
        if (typeAnnotationsToAdd == null) {
            typeAnnotationsToAdd = new ArrayList<TypeAnnotationNode>();
        }
        if (fields == null) {
            fields = new LinkedHashMap<String, GenericAnnotationData>();
        }
        if (methods == null) {
            methods = new LinkedHashMap<String, MethodAnnotationData>();
        }
    }

    public ClassAnnotationData() {
        this(new LinkedHashSet<String>(), new ArrayList<AnnotationNode>(), new LinkedHashSet<TypeAnnotationKey>(), new ArrayList<TypeAnnotationNode>(), new LinkedHashMap<String, GenericAnnotationData>(), new LinkedHashMap<String, MethodAnnotationData>());
    }

    public ClassAnnotationData(ClassAnnotationData other) {
        this(new LinkedHashSet<String>(other.annotationsToRemove), AnnotationsData.copyAnnotations(other.annotationsToAdd), new LinkedHashSet<TypeAnnotationKey>(other.typeAnnotationsToRemove), AnnotationsData.copyTypeAnnotations(other.typeAnnotationsToAdd), AnnotationsData.copyMap(other.fields, GenericAnnotationData::new), AnnotationsData.copyMap(other.methods, MethodAnnotationData::new));
    }

    ClassAnnotationData merge(ClassAnnotationData other) {
        LinkedHashSet<String> newAnnotationsToRemove = new LinkedHashSet<String>(this.annotationsToRemove);
        newAnnotationsToRemove.addAll(other.annotationsToRemove);
        ArrayList<AnnotationNode> newAnnotationsToAdd = new ArrayList<AnnotationNode>(this.annotationsToAdd);
        newAnnotationsToAdd.addAll(other.annotationsToAdd);
        LinkedHashSet<TypeAnnotationKey> newTypeAnnotationsToRemove = new LinkedHashSet<TypeAnnotationKey>(this.typeAnnotationsToRemove);
        newTypeAnnotationsToRemove.addAll(other.typeAnnotationsToRemove);
        ArrayList<TypeAnnotationNode> newTypeAnnotationsToAdd = new ArrayList<TypeAnnotationNode>(this.typeAnnotationsToAdd);
        LinkedHashMap<String, GenericAnnotationData> newFields = new LinkedHashMap<String, GenericAnnotationData>(this.fields);
        other.fields.forEach((key, value) -> newFields.merge((String)key, (GenericAnnotationData)value, GenericAnnotationData::merge));
        LinkedHashMap<String, MethodAnnotationData> newMethods = new LinkedHashMap<String, MethodAnnotationData>(this.methods);
        other.methods.forEach((key, value) -> newMethods.merge((String)key, (MethodAnnotationData)value, MethodAnnotationData::merge));
        return new ClassAnnotationData(newAnnotationsToRemove, newAnnotationsToAdd, newTypeAnnotationsToRemove, newTypeAnnotationsToAdd, newFields, newMethods);
    }

    ClassAnnotationData remap(String className, TinyRemapper remapper) {
        return new ClassAnnotationData(this.annotationsToRemove.stream().map(arg_0 -> ((TrRemapper)remapper.getEnvironment().getRemapper()).map(arg_0)).collect(Collectors.toCollection(LinkedHashSet::new)), this.annotationsToAdd.stream().map(ann -> AnnotationsData.remap(ann, remapper)).collect(Collectors.toCollection(ArrayList::new)), this.typeAnnotationsToRemove.stream().map(key -> key.remap(remapper)).collect(Collectors.toCollection(LinkedHashSet::new)), this.typeAnnotationsToAdd.stream().map(ann -> AnnotationsData.remap(ann, remapper)).collect(Collectors.toCollection(ArrayList::new)), AnnotationsData.remapMap(this.fields, entry -> ClassAnnotationData.remapField(className, (String)entry.getKey(), remapper), entry -> ((GenericAnnotationData)entry.getValue()).remap(remapper)), AnnotationsData.remapMap(this.methods, entry -> ClassAnnotationData.remapMethod(className, (String)entry.getKey(), remapper), entry -> ((MethodAnnotationData)entry.getValue()).remap(remapper)));
    }

    private static String remapField(String className, String field, TinyRemapper remapper) {
        String[] nameDesc = field.split(":", 2);
        if (nameDesc.length != 2) {
            return field;
        }
        TrRemapper trRemapper = remapper.getEnvironment().getRemapper();
        return trRemapper.mapFieldName(className, nameDesc[0], nameDesc[1]) + ":" + trRemapper.mapDesc(nameDesc[1]);
    }

    private static String remapMethod(String className, String method, TinyRemapper remapper) {
        int parenIndex = method.indexOf(40);
        if (parenIndex == -1) {
            return method;
        }
        String name = method.substring(0, parenIndex);
        String desc = method.substring(parenIndex);
        TrRemapper trRemapper = remapper.getEnvironment().getRemapper();
        return trRemapper.mapMethodName(className, name, desc) + trRemapper.mapMethodDesc(desc);
    }

    public int modifyAccessFlags(int access) {
        if (this.annotationsToRemove.contains("java/lang/Deprecated")) {
            access &= 0xFFFDFFFF;
        }
        if (this.annotationsToAdd.stream().anyMatch(ann -> "Ljava/lang/Deprecated;".equals(ann.desc))) {
            access |= 0x20000;
        }
        return access;
    }

    public @Nullable GenericAnnotationData getFieldData(String fieldName, String fieldDesc) {
        return this.fields.get(fieldName + ":" + fieldDesc);
    }

    public @Nullable MethodAnnotationData getMethodData(String methodName, String methodDesc) {
        return this.methods.get(methodName + methodDesc);
    }
}

