/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.util.download;

import java.util.Objects;
import java.util.function.Function;
import net.fabricmc.loom.util.download.DownloadProgressListener;
import org.gradle.internal.logging.progress.ProgressLogger;
import org.jspecify.annotations.Nullable;

public class GradleDownloadProgressListener
implements DownloadProgressListener {
    private final String name;
    private final Function<String, ProgressLogger> progressLoggerFactory;
    private static final long REPORT_INTERVAL_MS = 500L;
    private @Nullable ProgressLogger progressLogger;
    private long lastReportTime = 0L;
    private static final long KB = 1024L;
    private static final long MB = 0x100000L;
    private static final long GB = 0x40000000L;
    private static final double KB_DIVISOR = 1024.0;
    private static final double MB_DIVISOR = 1048576.0;
    private static final double GB_DIVISOR = 1.073741824E9;

    public GradleDownloadProgressListener(String name, Function<String, ProgressLogger> progressLoggerFactory) {
        this.name = name;
        this.progressLoggerFactory = progressLoggerFactory;
    }

    @Override
    public void onStart() {
        this.progressLogger = this.progressLoggerFactory.apply(this.name);
        this.lastReportTime = 0L;
    }

    @Override
    public void onProgress(long bytesTransferred, long contentLength) {
        Objects.requireNonNull(this.progressLogger);
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastReportTime >= 500L || bytesTransferred >= contentLength) {
            this.progressLogger.progress("Downloading %s - %s / %s".formatted(this.name, GradleDownloadProgressListener.humanBytes(bytesTransferred), GradleDownloadProgressListener.humanBytes(contentLength)));
            this.lastReportTime = currentTime;
        }
    }

    @Override
    public void onEnd() {
        if (this.progressLogger != null) {
            this.progressLogger.completed();
            this.progressLogger = null;
        }
    }

    private static String humanBytes(long bytes) {
        if (bytes < 1024L) {
            return bytes + " B";
        }
        if (bytes < 0x100000L) {
            return (double)bytes / 1024.0 + " KB";
        }
        if (bytes < 0x40000000L) {
            return String.format("%.2f MB", (double)bytes / 1048576.0);
        }
        return String.format("%.2f GB", (double)bytes / 1.073741824E9);
    }
}

