/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.providers.mappings.unpick;

import com.google.gson.JsonObject;
import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Objects;
import net.fabricmc.loom.LoomGradlePlugin;
import net.fabricmc.loom.api.mappings.layered.MappingsNamespace;
import org.jspecify.annotations.Nullable;

public sealed interface UnpickMetadata {
    public static final String UNPICK_METADATA_PATH = "extras/unpick.json";
    public static final String UNPICK_DEFINITIONS_PATH = "extras/definitions.unpick";

    public boolean hasConstants();

    public boolean hasConstantsLocation();

    public UnpickMetadata withConstants(String var1);

    default public UnpickMetadata withoutConstants() {
        return this.withConstants(null);
    }

    public static String toJson(UnpickMetadata metadata) {
        JsonObject json = LoomGradlePlugin.GSON.toJsonTree((Object)metadata).getAsJsonObject();
        UnpickMetadata unpickMetadata = metadata;
        Objects.requireNonNull(unpickMetadata);
        UnpickMetadata unpickMetadata2 = unpickMetadata;
        int n = 0;
        int version = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{V1.class, V2.class}, (Object)unpickMetadata2, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                V1 v1 = (V1)unpickMetadata2;
                yield 1;
            }
            case 1 -> {
                V2 v2 = (V2)unpickMetadata2;
                yield 2;
            }
        };
        json.addProperty("version", (Number)version);
        return json.toString();
    }

    public static UnpickMetadata parse(Path path) throws IOException {
        JsonObject jsonObject = (JsonObject)LoomGradlePlugin.GSON.fromJson(Files.readString(path, StandardCharsets.UTF_8), JsonObject.class);
        if (!jsonObject.has("version")) {
            throw new UnsupportedOperationException("Missing unpick metadata version");
        }
        int version = jsonObject.get("version").getAsInt();
        switch (version) {
            case 1: {
                return new V1(UnpickMetadata.getString(jsonObject, "unpickGroup"), UnpickMetadata.getString(jsonObject, "unpickVersion"));
            }
            case 2: {
                return new V2(UnpickMetadata.getString(jsonObject, "namespace"), UnpickMetadata.getOptionalString(jsonObject, "constants"));
            }
        }
        throw new UnsupportedOperationException("Unsupported unpick metadata version: %s. Please update loom.".formatted(version));
    }

    private static String getString(JsonObject jsonObject, String key) {
        if (!jsonObject.has(key)) {
            throw new UnsupportedOperationException("Missing unpick metadata %s".formatted(key));
        }
        return jsonObject.get(key).getAsString();
    }

    private static @Nullable String getOptionalString(JsonObject jsonObject, String key) {
        return jsonObject.has(key) ? jsonObject.get(key).getAsString() : null;
    }

    public record V1(@Deprecated String unpickGroup, @Deprecated String unpickVersion) implements UnpickMetadata
    {
        @Override
        public boolean hasConstants() {
            return true;
        }

        @Override
        public boolean hasConstantsLocation() {
            return false;
        }

        @Override
        public UnpickMetadata withConstants(String constants) {
            return new V2(MappingsNamespace.NAMED.toString(), constants);
        }
    }

    public record V2(String namespace, @Nullable String constants) implements UnpickMetadata
    {
        @Override
        public boolean hasConstants() {
            return this.constants != null;
        }

        @Override
        public boolean hasConstantsLocation() {
            return true;
        }

        @Override
        public UnpickMetadata withConstants(String constants) {
            return new V2(this.namespace, constants);
        }
    }
}

