/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.util;

import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import net.fabricmc.loom.util.Lazy;
import net.fabricmc.loom.util.Platform;
import org.gradle.api.Project;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OneDrive {
    private static final List<String> ENV_VARS = List.of("OneDrive", "OneDriveConsumer", "OneDriveCommercial");
    private static final Supplier<List<Path>> ONE_DRIVE_PATHS = Lazy.of(OneDrive::getOneDrivePaths);
    private static final Logger LOGGER = LoggerFactory.getLogger(OneDrive.class);

    private OneDrive() {
    }

    public static void verify(Project project) {
        if (!Platform.CURRENT.getOperatingSystem().isWindows()) {
            return;
        }
        Path projectDir = project.getProjectDir().toPath();
        if (OneDrive.isInOneDrive(projectDir)) {
            LOGGER.warn("Project directory '{}' is located in OneDrive. This is known to cause issues and slower performance. Consider moving the project to a different location.", (Object)projectDir);
        }
    }

    private static boolean isInOneDrive(Path path) {
        Path normalized = path.toAbsolutePath().normalize();
        for (Path oneDrivePath : ONE_DRIVE_PATHS.get()) {
            if (!normalized.startsWith(oneDrivePath)) continue;
            return true;
        }
        return false;
    }

    private static List<Path> getOneDrivePaths() {
        ArrayList<Path> paths = new ArrayList<Path>();
        for (String envVar : ENV_VARS) {
            String value = System.getenv(envVar);
            if (value == null || value.isEmpty()) continue;
            try {
                Path path = Path.of(value, new String[0]);
                paths.add(path.toAbsolutePath().normalize());
            }
            catch (InvalidPathException invalidPathException) {}
        }
        return Collections.unmodifiableList(paths);
    }
}

