/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.processors.speccontext;

import java.io.File;
import java.nio.file.Path;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import net.fabricmc.loom.api.RemapConfigurationSettings;
import net.fabricmc.loom.api.mappings.layered.MappingsNamespace;
import net.fabricmc.loom.configuration.processors.speccontext.ProjectView;
import org.gradle.api.NamedDomainObjectList;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.attributes.Usage;

public interface RemappedProjectView
extends ProjectView {
    public Function<RemapConfigurationSettings, Stream<Path>> resolveArtifacts(ProjectView.ArtifactUsage var1);

    public NamedDomainObjectList<RemapConfigurationSettings> getRemapConfigurations();

    public List<RemapConfigurationSettings> getCompileRemapConfigurations();

    public List<RemapConfigurationSettings> getRuntimeRemapConfigurations();

    public MappingsNamespace getProductionNamespace();

    public static class Impl
    extends ProjectView.AbstractProjectView
    implements RemappedProjectView {
        public Impl(Project project) {
            super(project);
        }

        @Override
        public Function<RemapConfigurationSettings, Stream<Path>> resolveArtifacts(ProjectView.ArtifactUsage artifactUsage) {
            Usage usage = (Usage)this.project.getObjects().named(Usage.class, artifactUsage.getGradleUsage());
            return settings -> {
                Configuration configuration = ((Configuration)settings.getSourceConfiguration().get()).copyRecursive();
                configuration.setCanBeConsumed(false);
                configuration.attributes(attributes -> attributes.attribute(Usage.USAGE_ATTRIBUTE, (Object)usage));
                return configuration.resolve().stream().map(File::toPath);
            };
        }

        @Override
        public NamedDomainObjectList<RemapConfigurationSettings> getRemapConfigurations() {
            return this.extension.getRemapConfigurations();
        }

        @Override
        public List<RemapConfigurationSettings> getCompileRemapConfigurations() {
            return this.extension.getCompileRemapConfigurations();
        }

        @Override
        public List<RemapConfigurationSettings> getRuntimeRemapConfigurations() {
            return this.extension.getRuntimeRemapConfigurations();
        }

        @Override
        public MappingsNamespace getProductionNamespace() {
            return (MappingsNamespace)((Object)this.extension.getProductionNamespaceEnum().get());
        }
    }
}

