/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.providers.mappings.file;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import net.fabricmc.loom.api.mappings.layered.MappingLayer;
import net.fabricmc.loom.api.mappings.layered.MappingsNamespace;
import net.fabricmc.loom.configuration.providers.mappings.extras.annotations.AnnotationsData;
import net.fabricmc.loom.configuration.providers.mappings.extras.annotations.AnnotationsLayer;
import net.fabricmc.loom.configuration.providers.mappings.extras.unpick.UnpickLayer;
import net.fabricmc.loom.configuration.providers.mappings.intermediary.IntermediaryMappingLayer;
import net.fabricmc.loom.util.FileSystemUtil;
import net.fabricmc.loom.util.ZipUtils;
import net.fabricmc.mappingio.MappingReader;
import net.fabricmc.mappingio.MappingVisitor;
import net.fabricmc.mappingio.adapter.MappingNsRenamer;
import net.fabricmc.mappingio.adapter.MappingSourceNsSwitch;
import net.fabricmc.mappingio.format.MappingFormat;
import org.jspecify.annotations.Nullable;

public record FileMappingsLayer(Path path, String mappingPath, String fallbackSourceNamespace, String fallbackTargetNamespace, boolean enigma, boolean unpick, boolean annotations, String mergeNamespace) implements MappingLayer,
UnpickLayer,
AnnotationsLayer
{
    @Override
    public void visit(MappingVisitor mappingVisitor) throws IOException {
        if (!ZipUtils.isZip(this.path)) {
            this.visit(this.path, mappingVisitor);
        } else {
            try (FileSystemUtil.Delegate fileSystem = FileSystemUtil.getJarFileSystem(this.path);){
                this.visit(fileSystem.get().getPath(this.mappingPath, new String[0]), mappingVisitor);
            }
        }
    }

    private void visit(Path path, MappingVisitor mappingVisitor) throws IOException {
        MappingSourceNsSwitch nsSwitch = new MappingSourceNsSwitch(mappingVisitor, this.mergeNamespace.toString());
        Map<String, String> fallbackNamespaceReplacements = Map.of("source", this.fallbackSourceNamespace, "target", this.fallbackTargetNamespace);
        MappingNsRenamer renamer = new MappingNsRenamer((MappingVisitor)nsSwitch, fallbackNamespaceReplacements);
        MappingReader.read((Path)path, (MappingFormat)(this.enigma ? MappingFormat.ENIGMA_DIR : null), (MappingVisitor)renamer);
    }

    @Override
    public MappingsNamespace getSourceNamespace() {
        return MappingsNamespace.of(this.mergeNamespace);
    }

    @Override
    public List<Class<? extends MappingLayer>> dependsOn() {
        if (this.mergeNamespace.equals(MappingsNamespace.INTERMEDIARY.toString()) || this.fallbackSourceNamespace.equals(MappingsNamespace.INTERMEDIARY.toString())) {
            return List.of(IntermediaryMappingLayer.class);
        }
        return List.of();
    }

    @Override
    public @Nullable UnpickLayer.UnpickData getUnpickData() throws IOException {
        if (!this.unpick) {
            return null;
        }
        if (!ZipUtils.isZip(this.path)) {
            throw new UnsupportedOperationException("Unpick is only supported for zip file mapping layers.");
        }
        try (FileSystemUtil.Delegate fileSystem = FileSystemUtil.getJarFileSystem(this.path);){
            Path unpickMetadata = fileSystem.get().getPath("extras/unpick.json", new String[0]);
            Path unpickDefinitions = fileSystem.get().getPath("extras/definitions.unpick", new String[0]);
            if (!Files.exists(unpickMetadata, new LinkOption[0])) {
                UnpickLayer.UnpickData unpickData = null;
                return unpickData;
            }
            UnpickLayer.UnpickData unpickData = UnpickLayer.UnpickData.read(unpickMetadata, unpickDefinitions);
            return unpickData;
        }
    }

    @Override
    public @Nullable AnnotationsData getAnnotationsData() throws IOException {
        if (!this.annotations) {
            return null;
        }
        if (!ZipUtils.isZip(this.path)) {
            throw new UnsupportedOperationException("Annotations data is only supported for zip file mapping layers.");
        }
        try (FileSystemUtil.Delegate fileSystem = FileSystemUtil.getJarFileSystem(this.path);){
            AnnotationsData annotationsData;
            block16: {
                Path annotations = fileSystem.get().getPath("extras/annotations.json", new String[0]);
                if (!Files.exists(annotations, new LinkOption[0])) {
                    AnnotationsData annotationsData2 = null;
                    return annotationsData2;
                }
                BufferedReader reader = Files.newBufferedReader(annotations);
                try {
                    annotationsData = AnnotationsData.read(reader);
                    if (reader == null) break block16;
                }
                catch (Throwable throwable) {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                reader.close();
            }
            return annotationsData;
        }
    }
}

