/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.providers.minecraft.mapped;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringJoiner;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.api.mappings.layered.MappingsNamespace;
import net.fabricmc.loom.configuration.ConfigContext;
import net.fabricmc.loom.configuration.mods.dependency.LocalMavenHelper;
import net.fabricmc.loom.configuration.providers.mappings.MappingConfiguration;
import net.fabricmc.loom.configuration.providers.mappings.extras.annotations.AnnotationsData;
import net.fabricmc.loom.configuration.providers.minecraft.AnnotationsApplyVisitor;
import net.fabricmc.loom.configuration.providers.minecraft.MinecraftJar;
import net.fabricmc.loom.configuration.providers.minecraft.MinecraftProvider;
import net.fabricmc.loom.configuration.providers.minecraft.MinecraftSourceSets;
import net.fabricmc.loom.configuration.providers.minecraft.MinecraftVersionMeta;
import net.fabricmc.loom.configuration.providers.minecraft.SignatureFixerApplyVisitor;
import net.fabricmc.loom.configuration.providers.minecraft.mapped.MappedMinecraftProvider;
import net.fabricmc.loom.extension.LoomFiles;
import net.fabricmc.loom.util.SidedClassVisitor;
import net.fabricmc.loom.util.TinyRemapperHelper;
import net.fabricmc.tinyremapper.OutputConsumerPath;
import net.fabricmc.tinyremapper.TinyRemapper;
import org.gradle.api.Project;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMappedMinecraftProvider<M extends MinecraftProvider>
implements MappedMinecraftProvider.ProviderImpl {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractMappedMinecraftProvider.class);
    protected final M minecraftProvider;
    private final Project project;
    protected final LoomGradleExtension extension;

    public AbstractMappedMinecraftProvider(Project project, M minecraftProvider) {
        this.minecraftProvider = minecraftProvider;
        this.project = project;
        this.extension = LoomGradleExtension.get(project);
    }

    public abstract MappingsNamespace getTargetNamespace();

    public abstract List<RemappedJars> getRemappedJars();

    public List<? extends OutputJar> getOutputJars() {
        return this.getRemappedJars();
    }

    public List<MinecraftJar.Type> getDependencyTypes() {
        return Collections.emptyList();
    }

    public List<MinecraftJar> provide(ProvideContext context) throws Exception {
        List<MinecraftJar.Type> dependencyTargets;
        List<RemappedJars> remappedJars = this.getRemappedJars();
        List<MinecraftJar> minecraftJars = remappedJars.stream().map(RemappedJars::outputJar).toList();
        if (remappedJars.isEmpty()) {
            throw new IllegalStateException("No remapped jars provided");
        }
        if (this.shouldRefreshOutputs(context)) {
            try {
                this.remapInputs(remappedJars, context.configContext());
                this.createBackupJars(minecraftJars);
            }
            catch (Throwable t) {
                this.cleanOutputs(remappedJars);
                throw new RuntimeException("Failed to remap minecraft", t);
            }
        }
        if (context.applyDependencies() && !(dependencyTargets = this.getDependencyTypes()).isEmpty()) {
            MinecraftSourceSets.get(this.getProject()).applyDependencies((configuration, type) -> this.getProject().getDependencies().add(configuration, (Object)this.getDependencyNotation((MinecraftJar.Type)((Object)type))), dependencyTargets);
        }
        return minecraftJars;
    }

    public static Path getBackupJarPath(MinecraftJar minecraftJar) {
        Path outputJarPath = minecraftJar.getPath();
        return outputJarPath.resolveSibling(String.valueOf(outputJarPath.getFileName()) + ".backup");
    }

    protected void createBackupJars(List<MinecraftJar> minecraftJars) throws IOException {
        for (MinecraftJar minecraftJar : minecraftJars) {
            Files.copy(minecraftJar.getPath(), AbstractMappedMinecraftProvider.getBackupJarPath(minecraftJar), StandardCopyOption.REPLACE_EXISTING);
        }
    }

    @Override
    public Path getJar(MinecraftJar.Type type) {
        return this.getMavenHelper(type).getOutputFile(null);
    }

    public abstract MavenScope getMavenScope();

    public LocalMavenHelper getMavenHelper(MinecraftJar.Type type) {
        return new LocalMavenHelper("net.minecraft", this.getName(type), this.getVersion(), null, this.getMavenScope().getRoot(this.extension));
    }

    protected String getName(MinecraftJar.Type type) {
        StringJoiner sj = new StringJoiner("-");
        sj.add("minecraft");
        sj.add(type.toString());
        if (!this.extension.disableObfuscation()) {
            String intermediateName = this.extension.getIntermediateMappingsProvider().getName();
            if (!intermediateName.equals("intermediary-v2")) {
                sj.add(intermediateName);
            }
        } else {
            sj.add("deobf");
        }
        if (this.getTargetNamespace() != MappingsNamespace.NAMED) {
            sj.add(this.getTargetNamespace().name());
        }
        return sj.toString().toLowerCase(Locale.ROOT);
    }

    protected String getVersion() {
        if (this.extension.disableObfuscation()) {
            return this.extension.getMinecraftProvider().minecraftVersion();
        }
        return "%s-%s".formatted(this.extension.getMinecraftProvider().minecraftVersion(), this.extension.getMappingConfiguration().mappingsIdentifier());
    }

    protected String getDependencyNotation(MinecraftJar.Type type) {
        return "net.minecraft:%s:%s".formatted(this.getName(type), this.getVersion());
    }

    protected boolean shouldRefreshOutputs(ProvideContext context) {
        if (context.refreshOutputs()) {
            LOGGER.info("Refreshing outputs for mapped jar, as refresh outputs was requested");
            return true;
        }
        List<OutputJar> outputJars = this.getOutputJars();
        if (outputJars.isEmpty()) {
            throw new IllegalStateException("No output jars provided");
        }
        for (OutputJar outputJar : outputJars) {
            if (this.getMavenHelper(outputJar.type()).exists(null)) continue;
            LOGGER.info("Refreshing outputs for mapped jar, as {} does not exist", (Object)outputJar.outputJar());
            return true;
        }
        for (OutputJar outputJar : outputJars) {
            if (Files.exists(AbstractMappedMinecraftProvider.getBackupJarPath(outputJar.outputJar()), new LinkOption[0])) continue;
            LOGGER.info("Refreshing outputs for mapped jar, as backup jar does not exist for {}", (Object)outputJar.outputJar());
            return true;
        }
        LOGGER.debug("All outputs are up to date");
        return false;
    }

    private void remapInputs(List<RemappedJars> remappedJars, ConfigContext configContext) throws IOException {
        this.cleanOutputs(remappedJars);
        for (RemappedJars remappedJar : remappedJars) {
            this.remapJar(remappedJar, configContext);
        }
    }

    protected void remapJar(RemappedJars remappedJars, ConfigContext configContext) throws IOException {
        if (this.extension.disableObfuscation()) {
            Files.createDirectories(remappedJars.outputJarPath().getParent(), new FileAttribute[0]);
            Files.copy(remappedJars.inputJar(), remappedJars.outputJarPath(), StandardCopyOption.REPLACE_EXISTING);
            this.getMavenHelper(remappedJars.type()).savePom();
            return;
        }
        MappingConfiguration mappingConfiguration = this.extension.getMappingConfiguration();
        String fromM = remappedJars.sourceNamespace().toString();
        String toM = this.getTargetNamespace().toString();
        Files.deleteIfExists(remappedJars.outputJarPath());
        AnnotationsData remappedAnnotations = AnnotationsData.getRemappedAnnotations(this.getTargetNamespace(), mappingConfiguration, this.getProject(), configContext.serviceFactory(), toM);
        Map<String, String> remappedSignatures = SignatureFixerApplyVisitor.getRemappedSignatures(this.getTargetNamespace() == MappingsNamespace.INTERMEDIARY, mappingConfiguration, this.getProject(), configContext.serviceFactory(), toM);
        MinecraftVersionMeta.JavaVersion javaVersion = ((MinecraftProvider)this.minecraftProvider).getVersionInfo().javaVersion();
        boolean fixRecords = javaVersion != null && javaVersion.majorVersion() >= 16;
        TinyRemapper remapper = TinyRemapperHelper.getTinyRemapper(this.getProject(), configContext.serviceFactory(), fromM, toM, fixRecords, builder -> {
            if (remappedAnnotations != null) {
                builder.extraPostApplyVisitor((TinyRemapper.ApplyVisitorProvider)new AnnotationsApplyVisitor(remappedAnnotations));
            }
            builder.extraPostApplyVisitor((TinyRemapper.ApplyVisitorProvider)new SignatureFixerApplyVisitor(remappedSignatures));
            this.configureRemapper(remappedJars, (TinyRemapper.Builder)builder);
        });
        try (OutputConsumerPath outputConsumer = new OutputConsumerPath.Builder(remappedJars.outputJarPath()).build();){
            outputConsumer.addNonClassFiles(remappedJars.inputJar());
            for (Path path : remappedJars.remapClasspath()) {
                remapper.readClassPath(new Path[]{path});
            }
            remapper.readInputs(new Path[]{remappedJars.inputJar()});
            remapper.apply((BiConsumer)outputConsumer);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to remap JAR " + String.valueOf(remappedJars.inputJar()) + " with mappings from " + String.valueOf(mappingConfiguration.tinyMappings), e);
        }
        finally {
            remapper.finish();
        }
        this.getMavenHelper(remappedJars.type()).savePom();
    }

    protected void configureRemapper(RemappedJars remappedJars, TinyRemapper.Builder tinyRemapperBuilder) {
    }

    public static void configureSplitRemapper(RemappedJars remappedJars, TinyRemapper.Builder tinyRemapperBuilder) {
        MinecraftJar outputJar = remappedJars.outputJar();
        assert (!outputJar.isMerged());
        if (outputJar.includesClient()) {
            assert (!outputJar.includesServer());
            tinyRemapperBuilder.extraPostApplyVisitor(SidedClassVisitor.CLIENT);
        }
    }

    private void cleanOutputs(List<RemappedJars> remappedJars) throws IOException {
        for (RemappedJars remappedJar : remappedJars) {
            Files.deleteIfExists(remappedJar.outputJarPath());
            Files.deleteIfExists(AbstractMappedMinecraftProvider.getBackupJarPath(remappedJar.outputJar()));
        }
    }

    public Project getProject() {
        return this.project;
    }

    public M getMinecraftProvider() {
        return this.minecraftProvider;
    }

    public record ProvideContext(boolean applyDependencies, boolean refreshOutputs, ConfigContext configContext) {
        ProvideContext withApplyDependencies(boolean applyDependencies) {
            return new ProvideContext(applyDependencies, this.refreshOutputs(), this.configContext());
        }
    }

    public static enum MavenScope {
        LOCAL(LoomFiles::getLocalMinecraftRepo),
        GLOBAL(LoomFiles::getGlobalMinecraftRepo);

        private final Function<LoomFiles, File> fileFunction;

        private MavenScope(Function<LoomFiles, File> fileFunction) {
            this.fileFunction = fileFunction;
        }

        public Path getRoot(LoomGradleExtension extension) {
            return this.fileFunction.apply(extension.getFiles()).toPath();
        }
    }

    public static sealed interface OutputJar
    permits RemappedJars, SimpleOutputJar {
        public MinecraftJar outputJar();

        default public MinecraftJar.Type type() {
            return this.outputJar().getType();
        }
    }

    public record RemappedJars(Path inputJar, MinecraftJar outputJar, MappingsNamespace sourceNamespace, Path[] remapClasspath) implements OutputJar
    {
        public Path outputJarPath() {
            return this.outputJar().getPath();
        }

        public String name() {
            return this.outputJar().getName();
        }
    }

    public record SimpleOutputJar(MinecraftJar outputJar) implements OutputJar
    {
    }
}

