/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.extension;

import java.util.Objects;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.api.LoomGradleExtensionAPI;
import net.fabricmc.loom.api.MixinExtensionAPI;
import net.fabricmc.loom.api.mappings.layered.MappingsNamespace;
import org.gradle.api.Action;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Project;
import org.gradle.api.logging.configuration.WarningMode;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.util.PatternSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MixinExtensionApiImpl
implements MixinExtensionAPI {
    private static final String MIXIN_AP_DISABLED_ERROR = "The mixin annotation is no longer enabled by default, you should remove any loom.mixin configuration. If you wish to continue to use the mixin AP you can set useLegacyMixinAp = true.";
    private static final Logger LOGGER = LoggerFactory.getLogger(MixinExtensionApiImpl.class);
    protected final Project project;
    protected final Property<Boolean> useMixinAp;
    private final Property<String> refmapTargetNamespace;
    private final MapProperty<String, String> messages;
    private final Property<Boolean> showMessageTypes;

    public MixinExtensionApiImpl(Project project) {
        this.project = Objects.requireNonNull(project);
        this.useMixinAp = project.getObjects().property(Boolean.class).convention((Object)false);
        this.refmapTargetNamespace = project.getObjects().property(String.class);
        this.refmapTargetNamespace.convention(project.provider(() -> LoomGradleExtension.get(project)).flatMap(LoomGradleExtensionAPI::getProductionNamespace).map(MappingsNamespace::toString));
        this.refmapTargetNamespace.finalizeValueOnRead();
        this.messages = project.getObjects().mapProperty(String.class, String.class);
        this.messages.finalizeValueOnRead();
        this.showMessageTypes = project.getObjects().property(Boolean.class);
        this.showMessageTypes.convention((Object)false).finalizeValueOnRead();
    }

    protected final PatternSet add0(SourceSet sourceSet, String refmapName) {
        return this.add0(sourceSet, (Provider<String>)this.project.provider(() -> refmapName));
    }

    protected abstract PatternSet add0(SourceSet var1, Provider<String> var2);

    @Override
    public Property<Boolean> getUseLegacyMixinAp() {
        return this.useMixinAp;
    }

    @Override
    public Property<String> getRefmapTargetNamespace() {
        if (!((Boolean)this.getUseLegacyMixinAp().get()).booleanValue()) {
            this.logLegacyMixinAPConfiguration();
        }
        return this.refmapTargetNamespace;
    }

    @Override
    public void add(SourceSet sourceSet, String refmapName, Action<PatternSet> action) {
        PatternSet pattern = this.add0(sourceSet, refmapName);
        action.execute((Object)pattern);
    }

    @Override
    public void add(SourceSet sourceSet, String refmapName) {
        this.add(sourceSet, refmapName, (Action<PatternSet>)((Action)x -> {}));
    }

    @Override
    public void add(String sourceSetName, String refmapName, Action<PatternSet> action) {
        this.add(sourceSetName, (Provider<String>)this.project.provider(() -> refmapName), action);
    }

    public void add(String sourceSetName, Provider<String> refmapName, Action<PatternSet> action) {
        this.add(this.resolveSourceSet(sourceSetName), refmapName, action);
    }

    public void add(SourceSet sourceSet, Provider<String> refmapName, Action<PatternSet> action) {
        PatternSet pattern = this.add0(sourceSet, refmapName);
        action.execute((Object)pattern);
    }

    @Override
    public void add(String sourceSetName, String refmapName) {
        this.add(sourceSetName, refmapName, (Action<PatternSet>)((Action)x -> {}));
    }

    @Override
    public void add(SourceSet sourceSet, Action<PatternSet> action) {
        this.add(sourceSet, (Provider<String>)this.getDefaultRefmapName(), action);
    }

    @Override
    public void add(SourceSet sourceSet) {
        this.add(sourceSet, (Action<PatternSet>)((Action)x -> {}));
    }

    @Override
    public void add(String sourceSetName, Action<PatternSet> action) {
        this.add(sourceSetName, (Provider<String>)this.getDefaultRefmapName(), action);
    }

    @Override
    public void add(String sourceSetName) {
        this.add(sourceSetName, (Action<PatternSet>)((Action)x -> {}));
    }

    @Override
    public MapProperty<String, String> getMessages() {
        return this.messages;
    }

    @Override
    public Property<Boolean> getShowMessageTypes() {
        return this.showMessageTypes;
    }

    @Override
    public void messages(Action<MapProperty<String, String>> action) {
        action.execute(this.messages);
    }

    private SourceSet resolveSourceSet(String sourceSetName) {
        SourceSet sourceSet = (SourceSet)((JavaPluginExtension)this.project.getExtensions().getByType(JavaPluginExtension.class)).getSourceSets().findByName(sourceSetName);
        if (sourceSet == null) {
            throw new InvalidUserDataException("No sourceSet " + sourceSetName + " was found");
        }
        return sourceSet;
    }

    final void logLegacyMixinAPConfiguration() {
        WarningMode warningMode = this.project.getGradle().getStartParameter().getWarningMode();
        if (warningMode == WarningMode.Fail) {
            throw new IllegalStateException(MIXIN_AP_DISABLED_ERROR);
        }
        if (warningMode != WarningMode.None) {
            LOGGER.warn(MIXIN_AP_DISABLED_ERROR);
        }
    }

    private final class EnsureCompile
    extends MixinExtensionApiImpl {
        private EnsureCompile(MixinExtensionApiImpl mixinExtensionApiImpl) {
            super(null);
            throw new RuntimeException();
        }

        @Override
        public Property<String> getDefaultRefmapName() {
            throw new RuntimeException("Yeah... something is really wrong");
        }

        @Override
        protected PatternSet add0(SourceSet sourceSet, Provider<String> refmapName) {
            throw new RuntimeException("Yeah... something is really wrong");
        }
    }
}

