/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.task.service;

import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.api.mappings.layered.MappingsNamespace;
import net.fabricmc.loom.configuration.providers.mappings.TinyMappingsService;
import net.fabricmc.loom.task.service.MappingsService;
import net.fabricmc.loom.task.service.MigrateMappingsService;
import net.fabricmc.loom.task.service.TinyRemapperService;
import net.fabricmc.loom.util.Checksum;
import net.fabricmc.loom.util.FileSystemUtil;
import net.fabricmc.loom.util.service.Service;
import net.fabricmc.loom.util.service.ServiceFactory;
import net.fabricmc.loom.util.service.ServiceType;
import net.fabricmc.mappingio.MappingReader;
import net.fabricmc.mappingio.MappingVisitor;
import net.fabricmc.mappingio.adapter.MappingNsRenamer;
import net.fabricmc.mappingio.format.tiny.Tiny2FileWriter;
import net.fabricmc.mappingio.tree.MemoryMappingTree;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Nested;
import org.objectweb.asm.commons.Remapper;

public final class MigrateClassTweakerMappingsService
extends Service<Options>
implements Closeable {
    private static final ServiceType<Options, MigrateClassTweakerMappingsService> TYPE = new ServiceType<Options, MigrateClassTweakerMappingsService>(Options.class, MigrateClassTweakerMappingsService.class);
    private static final String MIGRATION_TARGET_NS = "migrationTarget";

    public MigrateClassTweakerMappingsService(Options options, ServiceFactory serviceFactory) {
        super(options, serviceFactory);
    }

    public static Provider<Options> createOptions(Project project, Provider<String> targetMappings) {
        ConfigurableFileCollection minecraftLibraryClasspath = project.getObjects().fileCollection();
        minecraftLibraryClasspath.from(new Object[]{project.getConfigurations().getByName("minecraftLibraries")});
        minecraftLibraryClasspath.from(new Object[]{project.getConfigurations().getByName("minecraftRuntimeLibraries")});
        return TYPE.create(project, (Action<Options>)((Action)o -> {
            o.getMappings().set(MigrateMappingsService.createOptions(project, targetMappings));
            Provider mergedMappings = o.getMappings().flatMap(m -> MigrateClassTweakerMappingsService.createMergedMappingFile(project, targetMappings, m.getSourceMappings(), m.getTargetMappings()));
            o.getMergedMappings().set(mergedMappings);
            o.getTinyRemapperOptions().set(TinyRemapperService.TYPE.create(project, (Action<TinyRemapperService.Options>)((Action)o2 -> {
                o2.getClasspath().from(new Object[]{o.getMappings().map(m -> m.getClasspath().minus((FileCollection)minecraftLibraryClasspath))});
                o2.getFrom().set((Object)MappingsNamespace.NAMED.toString());
                o2.getTo().set((Object)MIGRATION_TARGET_NS);
                o2.getMappings().add(MappingsService.TYPE.create(project, (Action<MappingsService.Options>)((Action)o3 -> {
                    o3.getMappingsFile().set(mergedMappings);
                    o3.getFrom().set((Object)MappingsNamespace.NAMED.toString());
                    o3.getTo().set((Object)MIGRATION_TARGET_NS);
                    o3.getRemapLocals().set((Object)false);
                })));
                o2.getUselegacyMixinAP().set((Object)false);
            })));
        }));
    }

    public Remapper getRemapper() {
        TinyRemapperService service = (TinyRemapperService)this.getServiceFactory().get(((Options)this.getOptions()).getTinyRemapperOptions());
        return service.getTinyRemapperForRemapping().getEnvironment().getRemapper();
    }

    private static Provider<RegularFile> createMergedMappingFile(Project project, Provider<String> targetMappingsId, Provider<MappingsService.Options> sourceOptions, Provider<TinyMappingsService.Options> targetOptions) {
        return sourceOptions.flatMap(sourceOpt -> targetOptions.flatMap(targetOpt -> {
            Provider fileProvider = project.getLayout().getBuildDirectory().file(targetMappingsId.map(id -> "migrate-class-tweaker-mappings-" + Checksum.of(id).sha256().hex(16) + ".tiny"));
            return fileProvider.map(file -> {
                Path path = file.getAsFile().toPath();
                if (!Files.exists(path, new LinkOption[0]) || LoomGradleExtension.get(project).refreshDeps()) {
                    try {
                        MemoryMappingTree tree = MigrateClassTweakerMappingsService.mergeMappings(sourceOpt, targetOpt);
                        Files.createDirectories(path.getParent(), new FileAttribute[0]);
                        try (Tiny2FileWriter writer = new Tiny2FileWriter((Writer)Files.newBufferedWriter(path, StandardCharsets.UTF_8, new OpenOption[0]), false);){
                            tree.accept((MappingVisitor)writer);
                        }
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
                return file;
            });
        }));
    }

    private static MemoryMappingTree mergeMappings(MappingsService.Options sourceOptions, TinyMappingsService.Options targetOptions) throws IOException {
        MemoryMappingTree tree = new MemoryMappingTree();
        MappingReader.read((Path)((RegularFile)sourceOptions.getMappingsFile().get()).getAsFile().toPath(), (MappingVisitor)tree);
        MappingNsRenamer renamer = new MappingNsRenamer((MappingVisitor)tree, Map.of(MappingsNamespace.NAMED.toString(), MIGRATION_TARGET_NS));
        Path mappingFile = targetOptions.getMappings().getSingleFile().toPath();
        if (targetOptions.getZipEntryPath().isPresent()) {
            try (FileSystemUtil.Delegate fs = FileSystemUtil.getJarFileSystem(mappingFile);){
                MappingReader.read((Path)fs.getPath((String)targetOptions.getZipEntryPath().get(), new String[0]), (MappingVisitor)renamer);
            }
        } else {
            MappingReader.read((Path)mappingFile, (MappingVisitor)renamer);
        }
        return tree;
    }

    @Override
    public void close() throws IOException {
        Files.deleteIfExists(((RegularFile)((Options)this.getOptions()).getMergedMappings().get()).getAsFile().toPath());
    }

    public static interface Options
    extends Service.Options {
        @Nested
        public Property<MigrateMappingsService.Options> getMappings();

        @Nested
        public Property<TinyRemapperService.Options> getTinyRemapperOptions();

        @InputFile
        public RegularFileProperty getMergedMappings();
    }
}

