/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.ide;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.inject.Inject;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.configuration.ide.RunConfig;
import net.fabricmc.loom.configuration.providers.minecraft.MinecraftSourceSets;
import net.fabricmc.loom.util.Platform;
import net.fabricmc.loom.util.gradle.GradleUtils;
import net.fabricmc.loom.util.gradle.SourceSetHelper;
import org.gradle.api.Named;
import org.gradle.api.Project;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.SourceSet;
import org.jetbrains.annotations.ApiStatus;

public abstract class RunConfigSettings
implements Named {
    private final List<String> vmArgs = new ArrayList<String>();
    private final List<String> programArgs = new ArrayList<String>();
    private String environment;
    private String configName;
    private final Property<Boolean> appendProjectPathToConfigName;
    private String defaultMainClass;
    private final Property<String> mainClass;
    @ApiStatus.Internal
    @ApiStatus.Experimental
    private final Property<String> devLaunchMainClass;
    private Function<Project, SourceSet> source;
    private String runDir;
    private final String name;
    private boolean ideConfigGenerated;
    private final Map<String, Object> environmentVariables = new HashMap<String, Object>();
    private final Project project;
    private final LoomGradleExtension extension;

    @Inject
    public RunConfigSettings(Project project, String name) {
        this.name = name;
        this.project = project;
        this.appendProjectPathToConfigName = project.getObjects().property(Boolean.class).convention((Object)true);
        this.extension = LoomGradleExtension.get(project);
        this.ideConfigGenerated = GradleUtils.isRootProject(project);
        this.mainClass = project.getObjects().property(String.class).convention(project.provider(() -> {
            Objects.requireNonNull(this.environment, "Run config " + name + " must specify environment");
            Objects.requireNonNull(this.defaultMainClass, "Run config " + name + " must specify default main class");
            return RunConfig.getMainClass(this.environment, this.extension, this.defaultMainClass);
        }));
        this.devLaunchMainClass = project.getObjects().property(String.class).convention((Object)"net.fabricmc.devlaunchinjector.Main");
        this.setSource((Project p) -> {
            String sourceSetName = MinecraftSourceSets.get(p).getSourceSetForEnv(this.getEnvironment());
            return SourceSetHelper.getSourceSetByName(sourceSetName, p);
        });
        this.runDir("run");
    }

    public Project getProject() {
        return this.project;
    }

    public LoomGradleExtension getExtension() {
        return this.extension;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.configName = name;
    }

    public List<String> getVmArgs() {
        return this.vmArgs;
    }

    public List<String> getProgramArgs() {
        return this.programArgs;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    public String getConfigName() {
        return this.configName;
    }

    public void setConfigName(String name) {
        this.configName = name;
    }

    public Property<Boolean> getAppendProjectPathToConfigName() {
        return this.appendProjectPathToConfigName;
    }

    public String getDefaultMainClass() {
        return this.defaultMainClass;
    }

    public void setDefaultMainClass(String defaultMainClass) {
        this.defaultMainClass = defaultMainClass;
    }

    public Property<String> getMainClass() {
        return this.mainClass;
    }

    public String getRunDir() {
        return this.runDir;
    }

    public void setRunDir(String runDir) {
        this.runDir = runDir;
    }

    public SourceSet getSource(Project proj) {
        return this.source.apply(proj);
    }

    public void setSource(SourceSet source) {
        this.source = proj -> source;
    }

    public void setSource(Function<Project, SourceSet> sourceFn) {
        this.source = sourceFn;
    }

    public void environment(String environment) {
        this.setEnvironment(environment);
    }

    public void name(String name) {
        this.setConfigName(name);
    }

    public void defaultMainClass(String cls) {
        this.setDefaultMainClass(cls);
    }

    public void runDir(String dir) {
        this.setRunDir(dir);
    }

    public void vmArg(String arg) {
        this.vmArgs.add(arg);
    }

    public void vmArgs(String ... args) {
        this.vmArgs.addAll(Arrays.asList(args));
    }

    public void vmArgs(Collection<String> args) {
        this.vmArgs.addAll(args);
    }

    public void property(String name, String value) {
        this.vmArg("-D" + name + "=" + value);
    }

    public void property(String name) {
        this.vmArg("-D" + name);
    }

    public void properties(Map<String, String> props) {
        props.forEach(this::property);
    }

    public void programArg(String arg) {
        this.programArgs.add(arg);
    }

    public void programArgs(String ... args) {
        this.programArgs.addAll(Arrays.asList(args));
    }

    public void programArgs(Collection<String> args) {
        this.programArgs.addAll(args);
    }

    public void source(SourceSet source) {
        this.setSource(source);
    }

    public void source(String source) {
        this.setSource((Project proj) -> SourceSetHelper.getSourceSetByName(source, proj));
    }

    public void ideConfigGenerated(boolean ideConfigGenerated) {
        this.ideConfigGenerated = ideConfigGenerated;
    }

    public Map<String, Object> getEnvironmentVariables() {
        return this.environmentVariables;
    }

    public void environmentVariable(String name, Object value) {
        this.environmentVariables.put(name, value);
    }

    public void startFirstThread() {
        if (Platform.CURRENT.getOperatingSystem().isMacOS()) {
            this.vmArg("-XstartOnFirstThread");
        }
    }

    public void serverWithGui() {
        this.programArgs.removeIf("nogui"::equals);
    }

    public void client() {
        this.environment("client");
        this.defaultMainClass("net.fabricmc.loader.launch.knot.KnotClient");
        if (Platform.CURRENT.isRaspberryPi()) {
            this.getProject().getLogger().info("Raspberry Pi detected, setting MESA_GL_VERSION_OVERRIDE=4.3");
            this.environmentVariable("MESA_GL_VERSION_OVERRIDE", "4.3");
        }
    }

    public void server() {
        this.programArg("nogui");
        this.environment("server");
        this.defaultMainClass("net.fabricmc.loader.launch.knot.KnotServer");
    }

    public void inherit(RunConfigSettings parent) {
        this.vmArgs.addAll(0, parent.vmArgs);
        this.programArgs.addAll(0, parent.programArgs);
        this.environmentVariables.putAll(parent.environmentVariables);
        this.environment = parent.environment;
        this.configName = parent.configName;
        this.defaultMainClass = parent.defaultMainClass;
        this.source = parent.source;
        this.ideConfigGenerated = parent.ideConfigGenerated;
        this.getIdeConfigFolder().set(parent.getIdeConfigFolder());
    }

    public void makeRunDir() {
        File file = new File(this.getProject().getProjectDir(), this.runDir);
        if (!file.exists()) {
            file.mkdir();
        }
    }

    public boolean isIdeConfigGenerated() {
        return this.ideConfigGenerated;
    }

    public void setIdeConfigGenerated(boolean ideConfigGenerated) {
        this.ideConfigGenerated = ideConfigGenerated;
    }

    public abstract Property<String> getIdeConfigFolder();

    @ApiStatus.Internal
    @ApiStatus.Experimental
    public Property<String> devLaunchMainClass() {
        return this.devLaunchMainClass;
    }
}

