/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.decompilers.cfr;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import net.fabricmc.mappingio.MappingReader;
import net.fabricmc.mappingio.MappingVisitor;
import net.fabricmc.mappingio.adapter.MappingSourceNsSwitch;
import net.fabricmc.mappingio.tree.MappingTree;
import net.fabricmc.mappingio.tree.MemoryMappingTree;
import org.benf.cfr.reader.bytecode.analysis.types.JavaRefTypeInstance;
import org.benf.cfr.reader.bytecode.analysis.types.JavaTypeInstance;
import org.benf.cfr.reader.bytecode.analysis.types.MethodPrototype;
import org.benf.cfr.reader.entities.AccessFlag;
import org.benf.cfr.reader.entities.ClassFile;
import org.benf.cfr.reader.entities.ClassFileField;
import org.benf.cfr.reader.entities.Field;
import org.benf.cfr.reader.mapping.NullMapping;
import org.benf.cfr.reader.util.output.DelegatingDumper;
import org.benf.cfr.reader.util.output.Dumper;

public class CFRObfuscationMapping
extends NullMapping {
    private final MappingTree mappingTree;

    public CFRObfuscationMapping(Path mappings) {
        this.mappingTree = CFRObfuscationMapping.readMappings(mappings);
    }

    @Override
    public Dumper wrap(Dumper d) {
        return new JavadocProvidingDumper(d);
    }

    private static MappingTree readMappings(Path input) {
        MemoryMappingTree memoryMappingTree;
        block8: {
            BufferedReader reader = Files.newBufferedReader(input);
            try {
                MemoryMappingTree mappingTree = new MemoryMappingTree();
                MappingSourceNsSwitch nsSwitch = new MappingSourceNsSwitch((MappingVisitor)mappingTree, "named");
                MappingReader.read((Reader)reader, (MappingVisitor)nsSwitch);
                memoryMappingTree = mappingTree;
                if (reader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to read mappings", e);
                }
            }
            reader.close();
        }
        return memoryMappingTree;
    }

    private class JavadocProvidingDumper
    extends DelegatingDumper {
        JavadocProvidingDumper(Dumper delegate) {
            super(delegate);
        }

        public Dumper dumpClassDoc(JavaTypeInstance owner) {
            String comment;
            MappingTree.ClassMapping mapping = this.getClassMapping(owner);
            if (mapping == null) {
                return this;
            }
            ArrayList<String> recordComponentDocs = new ArrayList<String>();
            if (this.isRecord(owner)) {
                ClassFile classFile = ((JavaRefTypeInstance)owner).getClassFile();
                for (ClassFileField field : classFile.getFields()) {
                    String comment2;
                    MappingTree.FieldMapping fieldMapping;
                    if (field.getField().testAccessFlag(AccessFlag.ACC_STATIC) || (fieldMapping = mapping.getField(field.getFieldName(), field.getField().getDescriptor())) == null || (comment2 = fieldMapping.getComment()) == null) continue;
                    recordComponentDocs.add(String.format("@param %s %s", fieldMapping.getSrcName(), comment2));
                }
            }
            if ((comment = mapping.getComment()) != null || !recordComponentDocs.isEmpty()) {
                this.print("/**").newln();
                if (comment != null) {
                    for (String line : comment.split("\\R")) {
                        this.print(" * ").print(line).newln();
                    }
                    if (!recordComponentDocs.isEmpty()) {
                        this.print(" * ").newln();
                    }
                }
                if (comment != null && !recordComponentDocs.isEmpty()) {
                    this.print(" * ");
                }
                for (String componentDoc : recordComponentDocs) {
                    this.print(" * ").print(componentDoc).newln();
                }
                this.print(" */").newln();
            }
            return this;
        }

        public Dumper dumpMethodDoc(MethodPrototype method) {
            MappingTree.ClassMapping classMapping = this.getClassMapping(method.getOwner());
            if (classMapping == null) {
                return this;
            }
            ArrayList<String> lines = new ArrayList<String>();
            MappingTree.MethodMapping mapping = classMapping.getMethod(method.getName(), method.getOriginalDescriptor());
            if (mapping != null) {
                String comment = mapping.getComment();
                if (comment != null) {
                    lines.addAll(Arrays.asList(comment.split("\\R")));
                }
                Collection methodArgs = mapping.getArgs();
                ArrayList<String> params = new ArrayList<String>();
                for (MappingTree.MethodArgMapping arg : methodArgs) {
                    String argComment = arg.getComment();
                    if (argComment == null) continue;
                    params.addAll(Arrays.asList(("@param " + arg.getSrcName() + " " + argComment).split("\\R")));
                }
                if (!lines.isEmpty() && !params.isEmpty()) {
                    lines.add("");
                }
                lines.addAll(params);
            }
            if (!lines.isEmpty()) {
                this.print("/**").newln();
                for (String line : lines) {
                    this.print(" * ").print(line).newln();
                }
                this.print(" */").newln();
            }
            return this;
        }

        public Dumper dumpFieldDoc(Field field, JavaTypeInstance owner) {
            if (this.isRecord(owner) && !this.isStatic(field)) {
                return this;
            }
            MappingTree.ClassMapping classMapping = this.getClassMapping(owner);
            if (classMapping == null) {
                return this;
            }
            MappingTree.FieldMapping fieldMapping = classMapping.getField(field.getFieldName(), field.getDescriptor());
            if (fieldMapping != null) {
                this.dumpComment(fieldMapping.getComment());
            }
            return this;
        }

        private MappingTree.ClassMapping getClassMapping(JavaTypeInstance type) {
            String qualifiedName = type.getRawName().replace('.', '/');
            return CFRObfuscationMapping.this.mappingTree.getClass(qualifiedName);
        }

        private boolean isRecord(JavaTypeInstance javaTypeInstance) {
            if (javaTypeInstance instanceof JavaRefTypeInstance) {
                ClassFile classFile = ((JavaRefTypeInstance)javaTypeInstance).getClassFile();
                return classFile.getClassSignature().getSuperClass().getRawName().equals("java.lang.Record");
            }
            return false;
        }

        private boolean isStatic(Field field) {
            return field.testAccessFlag(AccessFlag.ACC_STATIC);
        }

        private void dumpComment(String comment) {
            if (comment == null || comment.isBlank()) {
                return;
            }
            this.print("/**").newln();
            for (String line : comment.split("\n")) {
                this.print(" * ").print(line).newln();
            }
            this.print(" */").newln();
        }
    }
}

